/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import wprover.CLine;
import wprover.CPoint;
import wprover.Circle;
import wprover.drawProcess;

public class AnimateC {
    double bx;
    double by;
    double width;
    double height;
    CPoint pA = null;
    Object onObj = null;
    int onType = 0;
    double dx;
    double dy;
    double csa;
    double sia;
    double gap = 2.0001;

    void Setstep(double step) {
        this.gap = step;
        this.reClaclulate();
    }

    AnimateC() {
    }

    AnimateC(CPoint p, Object obj, double width, double height) {
        this.pA = p;
        this.onObj = obj;
        this.width = width;
        this.height = height;
        if (obj instanceof CLine) {
            this.onType = 1;
        } else if (obj instanceof Circle) {
            this.onType = 2;
        } else {
            System.out.println("Error,undifined on type ");
        }
        this.reClaclulate();
    }

    public void reClaclulate() {
        if (this.onType == 2) {
            Circle c = (Circle)this.onObj;
            CPoint pt = c.getSidePoint();
            double rx = c.o.getx();
            double ry = c.o.gety();
            double r = Math.sqrt(Math.pow(pt.getx() - rx, 2.0) + Math.pow(pt.gety() - ry, 2.0));
            this.csa = Math.cos(-this.gap / r);
            this.sia = Math.sin(-this.gap / r);
        } else if (this.onType == 1) {
            CLine line = (CLine)this.onObj;
            CPoint[] pp = line.getTowSideOfLine();
            if (!line.isVertical()) {
                if (pp[0] == this.pA) {
                    pp[0] = pp[1];
                    pp[1] = this.pA;
                }
                this.dx = pp[1].getx() - pp[0].getx();
                this.dy = pp[1].gety() - pp[0].gety();
                double r = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
                this.dx /= r;
                this.dy /= r;
            }
        } else {
            System.out.println("Error,undifined on type ");
        }
    }

    public void startAnimate() {
        this.reClaclulate();
        this.bx = this.pA.getx();
        this.by = this.pA.gety();
    }

    public void stopAnimate() {
        this.pA.setXY(this.bx, this.by);
    }

    public void onTimer() {
        if (this.onType == 2) {
            Circle c = (Circle)this.onObj;
            double x = this.pA.getx();
            double y = this.pA.gety();
            double rx = c.o.getx();
            double ry = c.o.gety();
            double x0 = this.csa * (x - rx) - this.sia * (y - ry) + rx;
            double y0 = this.sia * (x - rx) + this.csa * (y - ry) + ry;
            this.pA.setXY(x0, y0);
        } else if (this.onType == 1) {
            double x = this.pA.getx() + this.gap * this.dx;
            double y = this.pA.gety() + this.gap * this.dy;
            if (x < 0.0 || x > this.width || y < 0.0 || y > this.height) {
                this.dx = -this.dx;
                this.dy = -this.dy;
            }
            this.pA.setXY(x, y);
        }
    }

    public void Save(DataOutputStream out) throws IOException {
        out.writeDouble(this.bx);
        out.writeDouble(this.by);
        out.writeDouble(this.width);
        out.writeDouble(this.height);
        out.writeInt(this.pA.id);
        out.writeInt(this.onType);
        if (this.onType == 1) {
            CLine line = (CLine)this.onObj;
            out.writeInt(line.id);
        } else {
            Circle c = (Circle)this.onObj;
            out.writeInt(c.id);
        }
        out.writeDouble(this.dx);
        out.writeDouble(this.dy);
        out.writeDouble(this.csa);
        out.writeDouble(this.sia);
        out.writeDouble(this.gap);
    }

    public void Load(DataInputStream in, drawProcess dp) throws IOException {
        this.bx = in.readDouble();
        this.by = in.readDouble();
        this.width = in.readDouble();
        this.height = in.readDouble();
        int d = in.readInt();
        this.pA = dp.getPointById(d);
        this.onType = in.readInt();
        d = in.readInt();
        this.onObj = this.onType == 1 ? dp.getLineByid(d) : dp.getCircleByid(d);
        this.dx = in.readDouble();
        this.dy = in.readDouble();
        this.csa = in.readDouble();
        this.sia = in.readDouble();
        this.gap = in.readDouble();
    }
}

