/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.awt.Font;
import java.awt.Graphics2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import wprover.CLine;
import wprover.CMisc;
import wprover.CPoint;
import wprover.drawData;
import wprover.drawProcess;
import wprover.drawType;

public class CAngle {
    int id = CMisc.id_count++;
    CLine lstart;
    CLine lend;
    int radius = 20;
    CPoint pstart;
    CPoint pend;
    drawType drawt = drawData.getCurrentAngleType();

    public CAngle() {
    }

    public CAngle(CLine l1, CLine l2, CPoint p1, CPoint p2) {
        this.lstart = l1;
        this.lend = l2;
        double[] r = CLine.Intersect(l1, l2);
        if (r == null) {
            System.out.println("line can not intersect");
        } else {
            CPoint p;
            int i;
            double x = p1.getx();
            double y = p1.gety();
            CPoint p11 = null;
            for (i = 0; i < l1.points.size(); ++i) {
                p = (CPoint)l1.points.get(i);
                if (!((p.getx() - r[0]) * (x - r[0]) + (p.gety() - r[1]) * (y - r[1]) > 0.001)) continue;
                if (p11 == null) {
                    p11 = p;
                    continue;
                }
                if (p11.x1.xindex <= p.x1.xindex) continue;
                p11 = p;
            }
            this.pstart = p11;
            x = p2.getx();
            y = p2.gety();
            p11 = null;
            for (i = 0; i < l2.points.size(); ++i) {
                p = (CPoint)l2.points.get(i);
                if (!((p.getx() - r[0]) * (x - r[0]) + (p.gety() - r[1]) * (y - r[1]) > 0.001)) continue;
                if (p11 == null) {
                    p11 = p;
                    continue;
                }
                if (p11.x1.xindex <= p.x1.xindex) continue;
                p11 = p;
            }
            this.pend = p11;
        }
        this.radius = (int)Math.sqrt(Math.pow(p2.getx() - r[0], 2.0) + Math.pow(p2.gety() - r[1], 2.0));
    }

    public CPoint CrossPoint() {
        return CLine.commonPoint(this.lstart, this.lend);
    }

    public String getDescription() {
        return "<" + this.pstart.name + CLine.commonPoint(this.lstart, this.lend) + this.pend.name;
    }

    public static CLine getCrossLine(CAngle g1, CAngle g2) {
        if (g1.lstart == g2.lstart || g1.lstart == g2.lend) {
            return g1.lstart;
        }
        if (g1.lend == g2.lstart || g1.lend == g2.lend) {
            return g1.lend;
        }
        return null;
    }

    public static CPoint canEqual(CAngle ag1, CAngle ag2) {
        CPoint pa = CLine.commonPoint(ag1.lstart, ag1.lend);
        CPoint pb = CLine.commonPoint(ag2.lstart, ag2.lend);
        CPoint p = pa.x1.xindex > pb.x1.xindex ? pa : pb;
        CPoint pa1 = ag1.pstart;
        if (p.x1.xindex < pa1.x1.xindex) {
            p = pa1;
        }
        CPoint pa2 = ag1.pend;
        if (p.x1.xindex < pa2.x1.xindex) {
            p = pa2;
        }
        CPoint pb1 = ag2.pstart;
        if (p.x1.xindex < pb1.x1.xindex) {
            p = pb1;
        }
        CPoint pb2 = ag2.pend;
        if (p.x1.xindex < pb2.x1.xindex) {
            p = pb2;
        }
        if (p.x1.Solved && p.y1.Solved) {
            return null;
        }
        return p;
    }

    public boolean isCatch(CPoint p) {
        double dr1;
        double dr;
        double[] r = CLine.Intersect(this.lstart, this.lend);
        if (r == null) {
            return false;
        }
        if (Math.abs(Math.sqrt(Math.pow(p.getx() - r[0], 2.0) + Math.pow(p.gety() - r[1], 2.0)) - (double)this.radius) > 5.0) {
            return false;
        }
        double dx1 = this.pstart.getx() - r[0];
        double dy1 = this.pstart.gety() - r[1];
        dy1 = -1.0 * dy1;
        double k1 = dy1 / dx1;
        double r1 = Math.atan(k1);
        if (dx1 < 0.0) {
            r1 += Math.PI;
        }
        double dx2 = this.pend.getx() - r[0];
        double dy2 = this.pend.gety() - r[1];
        dy2 = -1.0 * dy2;
        double k2 = dy2 / dx2;
        double r2 = Math.atan(k2);
        if (dx2 < 0.0) {
            r2 += Math.PI;
        }
        if ((dr = r2 - r1) > Math.PI) {
            dr -= Math.PI * 2;
        } else if (dr < -Math.PI) {
            dr += Math.PI * 2;
        }
        double dx3 = p.getx() - r[0];
        double dy3 = -(p.gety() - r[1]);
        double k3 = dy3 / dx3;
        double r3 = Math.atan(k3);
        if (dx3 < 0.0) {
            r3 += Math.PI;
        }
        if ((dr1 = r3 - r1) > Math.PI) {
            dr1 -= Math.PI * 2;
        } else if (dr1 < -Math.PI) {
            dr1 += Math.PI * 2;
        }
        return dr1 * dr > 0.0 && Math.abs(dr1) < Math.abs(dr);
    }

    public void draged(CPoint p) {
        double[] r = CLine.Intersect(this.lstart, this.lend);
        if (r == null) {
            return;
        }
        this.radius = (int)Math.sqrt(Math.pow(p.getx() - r[0], 2.0) + Math.pow(p.gety() - r[1], 2.0));
        if (this.radius < 20) {
            this.radius = 20;
        }
    }

    public void draw(Graphics2D g2, boolean isSelected) {
        double[] r = CLine.Intersect(this.lstart, this.lend);
        if (r == null) {
            return;
        }
        if (Math.abs(r[0]) > 10000.0) {
            boolean i = false;
        }
        double dx1 = this.pstart.getx() - r[0];
        double dy1 = this.pstart.gety() - r[1];
        dy1 = -1.0 * dy1;
        double k1 = dy1 / dx1;
        double r1 = Math.atan(k1);
        if (dx1 < 0.0) {
            r1 += Math.PI;
        }
        double t = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        dx1 /= t;
        dy1 /= t;
        double dx2 = this.pend.getx() - r[0];
        double dy2 = this.pend.gety() - r[1];
        dy2 = -1.0 * dy2;
        double k2 = dy2 / dx2;
        double r2 = Math.atan(k2);
        if (dx2 < 0.0) {
            r2 += Math.PI;
        }
        t = Math.sqrt(dx2 * dx2 + dy2 * dy2);
        double jx = (dx2 /= t) * (double)this.radius + r[0];
        double jy = -1.0 * (dy2 /= t) * (double)this.radius + r[1];
        int ri1 = (int)(180.0 * r1 / Math.PI);
        double dr = 180.0 * (r2 - r1) / Math.PI;
        double alpha = -1.0471975511965976;
        if (dr > 180.0) {
            dr -= 360.0;
        } else if (dr < -180.0) {
            dr += 360.0;
        }
        double rc = dr * Math.PI / 360.0;
        double cx = (dx1 * Math.cos(rc) - dy1 * Math.sin(rc)) * (double)(this.radius + 6) + r[0];
        double cy = -(dy1 * Math.cos(rc) + dx1 * Math.sin(rc)) * (double)(this.radius + 6) + r[1];
        double lr = 12.0;
        double dr1 = dr;
        if (dr > 0.0) {
            if ((dr -= 180.0 * Math.cos(1.5707963267948966 - (alpha = -alpha)) * lr * 1.0 / (Math.PI * 3 * (double)this.radius)) < 0.0) {
                dr = 0.0;
            }
        } else if ((dr += 180.0 * Math.cos(1.5707963267948966 + alpha) * lr * 1.0 / (Math.PI * 3 * (double)this.radius)) > 0.0) {
            dr = 0.0;
        }
        dy2 = -dy2;
        double c1 = Math.cos(alpha);
        double s1 = Math.sin(alpha);
        double c2 = Math.cos(Math.PI - alpha);
        double s2 = Math.sin(Math.PI - alpha);
        double jx1 = (dx2 * c1 - dy2 * s1) * lr + jx;
        double jy1 = (dy2 * c1 + dx2 * s1) * lr + jy;
        double jx2 = (dx2 * c2 - dy2 * s2) * lr + jx;
        double jy2 = (dy2 * c2 + dx2 * s2) * lr + jy;
        this.drawt.setdrawType(g2);
        if (!isSelected) {
            g2.setStroke(CMisc.NormalLineStroke);
        } else {
            g2.setColor(CMisc.AngleSelectedColor);
            g2.setStroke(CMisc.AngleSelectedStrok);
        }
        int k = (int)(dr1 * 10.0);
        if (dr1 * 10.0 - (double)k > 0.5 && dr1 > 0.0) {
            ++k;
        } else if (dr1 * 10.0 - (double)k < -0.5 && dr1 < 0.0) {
            --k;
        }
        dr = dr >= 0.0 ? (dr += 0.5) : (dr -= 0.5);
        int[] xp = new int[4];
        int[] yp = new int[4];
        xp[0] = (int)jx;
        xp[1] = (int)jx1;
        xp[2] = (int)(jx1 / 3.0 + jx2 / 3.0 + jx / 3.0);
        xp[3] = (int)jx2;
        yp[0] = (int)jy;
        yp[1] = (int)jy1;
        yp[2] = (int)(jy1 / 3.0 + jy2 / 3.0 + jy / 3.0);
        yp[3] = (int)jy2;
        g2.fillPolygon(xp, yp, 4);
        g2.drawArc((int)r[0] - this.radius, (int)r[1] - this.radius, this.radius * 2, this.radius * 2, ri1, (int)dr);
        g2.setFont(new Font("Dialog", 0, 12));
        g2.drawString("  " + Math.abs((double)k / 10.0) + "'", (int)cx, (int)cy);
    }

    public void Save(DataOutputStream out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.lstart.id);
        out.writeInt(this.lend.id);
        out.writeInt(this.radius);
        out.writeInt(this.pstart.id);
        out.writeInt(this.pend.id);
        this.drawt.Save(out);
    }

    public void Load(DataInputStream in, drawProcess dp) throws IOException {
        this.id = in.readInt();
        int dx = in.readInt();
        this.lstart = dp.getLineByid(dx);
        int dy = in.readInt();
        this.lend = dp.getLineByid(dy);
        this.radius = in.readInt();
        int px = in.readInt();
        this.pstart = dp.getPointById(px);
        int py = in.readInt();
        this.pend = dp.getPointById(py);
        this.drawt = new drawType();
        this.drawt.Load(in);
    }
}

