/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import wprover.CMisc;
import wprover.CPoint;
import wprover.drawProcess;

public class CDistance {
    int id = CMisc.id_count++;
    CPoint pstart;
    CPoint pend;

    public CDistance() {
    }

    public CDistance(CPoint p1, CPoint p2) {
        this.pstart = p1;
        this.pend = p2;
    }

    public void draw(Graphics2D g2) {
        double dis = Math.sqrt(Math.pow(this.pstart.getx() - this.pend.getx(), 2.0) + Math.pow(this.pstart.gety() - this.pend.gety(), 2.0));
        double x1 = this.pstart.getx();
        double y1 = this.pstart.gety();
        double x2 = this.pend.getx();
        double y2 = this.pend.gety();
        g2.setColor(Color.pink);
        float[] dash = new float[]{3.0f};
        g2.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f));
        g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        g2.setColor(Color.black);
        g2.drawString("" + this.pstart.name + this.pend.name + " = " + (float)((int)(dis * 100.0)) / 100.0f, (int)((x1 + x2) / 2.0), (int)((y1 + y2) / 2.0));
    }

    public void Save(DataOutputStream out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.pstart.id);
        out.writeInt(this.pend.id);
    }

    public void Load(DataInputStream in, drawProcess dp) throws IOException {
        this.id = in.readInt();
        this.pstart = dp.getPointById(in.readInt());
        this.pend = dp.getPointById(in.readInt());
    }
}

