/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import wprover.CMisc;
import wprover.CPoint;
import wprover.Circle;
import wprover.constraint;
import wprover.drawData;
import wprover.drawProcess;
import wprover.drawType;

public class CLine {
    public static final int LLine = 0;
    public static final int PLine = 1;
    public static final int TLine = 2;
    public static final int BLine = 3;
    public static final int CCLine = 4;
    int id = CMisc.id_count++;
    drawType drawt = drawData.getCurrentDrawType();
    String name = null;
    int type = 0;
    Vector points = new Vector();
    Vector cons = new Vector();

    public String getAllPointName() {
        String s = new String();
        for (int i = 0; i < this.points.size(); ++i) {
            CPoint p = (CPoint)this.points.get(i);
            s = i == 0 ? s + p.name : s + ", " + p.name;
        }
        return s;
    }

    public CPoint getfirstPoint() {
        CPoint p = null;
        for (int i = 0; i < this.points.size(); ++i) {
            CPoint pt = (CPoint)this.points.get(i);
            if (p == null) {
                p = pt;
                continue;
            }
            if (p.x1.xindex <= pt.x1.xindex) continue;
            p = pt;
        }
        return p;
    }

    public boolean isParallel(CLine line) {
        if (this.type != 1) {
            return false;
        }
        for (int i = 0; i < this.cons.size(); ++i) {
            constraint cs = (constraint)this.cons.get(i);
            if (cs.GetConstraintType() != 2) continue;
            CLine line1 = (CLine)cs.getelement(0);
            CLine line2 = (CLine)cs.getelement(1);
            if (line2 == this) {
                CLine l = line1;
                line1 = line2;
                line2 = l;
            }
            if (line2 == line) {
                return true;
            }
            if (line2.type != 1) continue;
            return line2.isParallel(line);
        }
        return false;
    }

    public boolean isVertical(CLine line) {
        for (int i = 0; i < this.cons.size(); ++i) {
            constraint cs = (constraint)this.cons.get(i);
            if (cs.GetConstraintType() != 3) continue;
            CLine line1 = (CLine)cs.getelement(0);
            CLine line2 = (CLine)cs.getelement(1);
            if (line2 == this) {
                CLine l = line1;
                line1 = line2;
                line2 = l;
            }
            return line2 == line && line1 == this;
        }
        return false;
    }

    public CPoint[] getTowSideOfLine() {
        CPoint p2 = null;
        CPoint p1 = null;
        for (int i = 0; i < this.points.size(); ++i) {
            CPoint p = (CPoint)this.points.get(i);
            if (p1 == null) {
                p1 = p;
                continue;
            }
            if (p.x1.xindex < p1.x1.xindex) {
                p2 = p1;
                p1 = p;
                continue;
            }
            if (p2 != null && p.x1.xindex >= p1.x1.xindex) continue;
            p2 = p;
        }
        if (p1 == null || p2 == null) {
            return null;
        }
        CPoint[] pl = new CPoint[]{p1, p2};
        return pl;
    }

    public String getDiscription() {
        CPoint[] s = this.getTowSideOfLine();
        if (s == null) {
            return this.name;
        }
        return s[0].name + s[1].name;
    }

    public CPoint[] getMaxMinPoint() {
        CPoint p;
        int i;
        if (this.points.size() < 2) {
            return null;
        }
        CPoint p1 = (CPoint)this.points.get(0);
        CPoint p2 = null;
        for (i = 1; i < this.points.size(); ++i) {
            p = (CPoint)this.points.get(i);
            if (p.x1.value < p1.x1.value) {
                if (p2 == null) {
                    p2 = p1;
                    p1 = p;
                    continue;
                }
                p1 = p;
                continue;
            }
            if (p2 != null && !(p.x1.value > p2.x1.value)) continue;
            p2 = p;
        }
        if (Math.abs(p1.x1.value - p2.x1.value) < 0.001) {
            p1 = (CPoint)this.points.get(0);
            p2 = null;
            for (i = 1; i < this.points.size(); ++i) {
                p = (CPoint)this.points.get(i);
                if (p.y1.value < p1.y1.value) {
                    if (p2 == null) {
                        p2 = p1;
                        p1 = p;
                        continue;
                    }
                    p1 = p;
                    continue;
                }
                if (p2 != null && !(p.y1.value > p2.y1.value)) continue;
                p2 = p;
            }
        }
        CPoint[] pl = new CPoint[]{p1, p2};
        return pl;
    }

    public constraint getcons(int i) {
        if (i >= 0 && i < this.cons.size()) {
            return (constraint)this.cons.get(i);
        }
        return null;
    }

    public int getconsSize() {
        return this.cons.size();
    }

    public boolean isVertical() {
        if (this.type == 0) {
            CPoint p1 = (CPoint)this.points.get(0);
            CPoint p2 = (CPoint)this.points.get(1);
            return Math.abs(p2.getx() - p1.getx()) < 0.01;
        }
        constraint cs = null;
        for (int i = 0; i < this.cons.size(); ++i) {
            cs = (constraint)this.cons.get(i);
            switch (cs.GetConstraintType()) {
                case 2: {
                    CLine line = (CLine)cs.getelement(1);
                    return line.isVertical();
                }
                case 3: {
                    CLine line = (CLine)cs.getelement(1);
                    return line.isHorizonal();
                }
                case 14: {
                    Circle c1 = (Circle)cs.getelement(1);
                    Circle c2 = (Circle)cs.getelement(2);
                    return Math.abs(c1.o.getx() - c2.o.getx()) < 0.01;
                }
            }
        }
        return false;
    }

    public boolean isHorizonal() {
        if (this.type == 0) {
            CPoint p1 = (CPoint)this.points.get(0);
            CPoint p2 = (CPoint)this.points.get(1);
            return Math.abs(p2.gety() - p1.gety()) < 0.01;
        }
        constraint cs = null;
        for (int i = 0; i < this.cons.size(); ++i) {
            cs = (constraint)this.cons.get(i);
            switch (cs.GetConstraintType()) {
                case 2: {
                    CLine line = (CLine)cs.getelement(1);
                    return line.isHorizonal();
                }
                case 3: {
                    CLine line = (CLine)cs.getelement(1);
                    return line.isVertical();
                }
                case 14: {
                    Circle c1 = (Circle)cs.getelement(1);
                    Circle c2 = (Circle)cs.getelement(2);
                    return Math.abs(c1.o.gety() - c2.o.gety()) < 0.01;
                }
            }
        }
        return false;
    }

    public double getK() {
        if (this.type == 0) {
            CPoint p1 = (CPoint)this.points.get(0);
            CPoint p2 = (CPoint)this.points.get(1);
            return (p2.gety() - p1.gety()) / (p2.getx() - p1.getx());
        }
        constraint cs = null;
        for (int i = 0; i < this.cons.size(); ++i) {
            cs = (constraint)this.cons.get(i);
            switch (cs.GetConstraintType()) {
                case 2: {
                    CLine line = (CLine)cs.getelement(1);
                    return line.getK();
                }
                case 3: {
                    CLine line = (CLine)cs.getelement(1);
                    return -1.0 / line.getK();
                }
                case 14: {
                    Circle c1 = (Circle)cs.getelement(1);
                    Circle c2 = (Circle)cs.getelement(2);
                    return (c1.o.getx() - c2.o.getx()) / (c1.o.gety() - c2.o.gety());
                }
            }
        }
        return 0.0;
    }

    public void addApoint(CPoint a) {
        if (!this.points.contains(a)) {
            this.points.add(a);
        }
    }

    public void addconstraint(constraint cs) {
        if (!this.cons.contains(cs)) {
            this.cons.add(cs);
        }
    }

    public void clearpoints() {
        this.points.clear();
    }

    public void setColorType(String c) {
        String str = new String(c);
    }

    public CLine(int type) {
        this.type = type;
    }

    public CLine(CPoint A, int type) {
        this.points.add(A);
        this.type = type;
    }

    public CLine(CPoint A, CPoint B, int Type2) {
        this.points.add(A);
        this.points.add(B);
        this.type = Type2;
    }

    public CLine(CPoint A, CPoint B) {
        this.points.add(A);
        this.points.add(B);
    }

    public CLine(CPoint A, CPoint B, String color) {
        this.points.add(A);
        this.points.add(B);
    }

    public void draw() {
        System.out.println("a line");
    }

    public boolean onLine(CPoint Y) {
        int counter = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            CPoint p = (CPoint)this.points.get(i);
            if (!this.isEqual(p, Y)) continue;
            ++counter;
        }
        if (counter == 0) {
            this.points.add(Y);
            Y.OnCircleOrOnLine = 1;
            return true;
        }
        return false;
    }

    public boolean onLine(CPoint Y, CPoint A, CPoint B) {
        CPoint p = new CPoint();
        int counter = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            p = (CPoint)this.points.get(i);
            if (!this.isEqual(A, p) && !this.isEqual(B, p)) continue;
            ++counter;
        }
        if (counter == 2) {
            this.points.add(Y);
            return true;
        }
        return false;
    }

    public boolean onLine(CPoint Y, CPoint A, CPoint B, String color) {
        CPoint p = new CPoint();
        int counter = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            p = (CPoint)this.points.get(i);
            if (!this.isEqual(A, p) && !this.isEqual(B, p)) continue;
            ++counter;
        }
        if (counter == 2) {
            this.points.add(Y);
            return true;
        }
        return false;
    }

    public boolean sameLine(CPoint A, CPoint B) {
        CPoint p = new CPoint();
        int counter = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            p = (CPoint)this.points.get(i);
            if (!this.isEqual(A, p) && !this.isEqual(B, p)) continue;
            ++counter;
        }
        return counter == 2;
    }

    public boolean isEqual(CPoint A, CPoint B) {
        return A.x1.xindex == B.x1.xindex && A.y1.xindex == B.y1.xindex;
    }

    public double distanceToPoint(double x, double y) {
        Object p = null;
        if (this.type == 4) {
            constraint cs = null;
            for (int i = 0; i < this.cons.size() && (cs = this.getcons(i)).GetConstraintType() != 14; ++i) {
            }
            if (cs == null) {
                return -1.0;
            }
            Circle c1 = (Circle)cs.getelement(1);
            Circle c2 = (Circle)cs.getelement(2);
            CPoint p1 = c1.o;
            CPoint p2 = c2.o;
            double x1 = p1.getx();
            double y1 = p1.gety();
            double x2 = p2.getx();
            double y2 = p2.gety();
            double r1 = c1.getRadius();
            double r2 = c2.getRadius();
            double r = Math.abs(-2.0 * x * (x1 - x2) + x1 * x1 - x2 * x2 - 2.0 * y * (y1 - y2) + y1 * y1 - y2 * y2 - r1 * r1 + r2 * r2);
            return r /= 2.0 * Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        }
        CPoint p2 = null;
        CPoint p1 = null;
        CPoint[] pl = this.getMaxMinPoint();
        if (pl == null && (this.type == 1 || this.type == 2)) {
            CPoint pt = (CPoint)this.points.get(0);
            double x1 = pt.getx();
            double y1 = pt.gety();
            if (this.isVertical()) {
                return Math.abs(x - x1);
            }
            double k = this.getK();
            double len = Math.abs(y - k * x - y1 + k * x1) / Math.sqrt(1.0 + k * k);
            return len;
        }
        p1 = pl[0];
        p2 = pl[1];
        double x1 = p1.getx();
        double y1 = p1.gety();
        double x2 = p2.getx();
        double y2 = p2.gety();
        if (Math.abs(x1 - x2) < 0.001) {
            return Math.abs(x - x1);
        }
        double k = -(y2 - y1) / (x2 - x1);
        double len = Math.abs(y + k * x - y1 - k * x1) / Math.sqrt(1.0 + k * k);
        return len;
    }

    public boolean inside(double x, double y) {
        CPoint p2 = null;
        CPoint p1 = null;
        CPoint[] pl = this.getMaxMinPoint();
        if (pl == null) {
            return true;
        }
        p1 = pl[0];
        p2 = pl[1];
        double x1 = p1.getx();
        double y1 = p1.gety();
        double x2 = p2.getx();
        double y2 = p2.gety();
        if (Math.abs(x1 - x2) < 5.0) {
            return (y - y1) * (y - y2) < 0.0;
        }
        return (x - x1) * (x - x2) < 0.0;
    }

    public boolean nearline(double x, double y, double eps) {
        return false;
    }

    public void pointonline(CPoint pt) {
        double yt;
        double xt;
        if (this.type == 4) {
            return;
        }
        CPoint p = (CPoint)this.points.get(0);
        double x1 = p.getx();
        double y1 = p.gety();
        double x3 = pt.x1.value;
        double y3 = pt.y1.value;
        if (this.type == 1 || this.type == 2 || this.type == 4) {
            if (this.isVertical()) {
                xt = x1;
                yt = y3;
            } else if (this.isHorizonal()) {
                xt = x3;
                yt = y1;
            } else {
                double k = this.getK();
                xt = ((y3 - y1) * k + x1 * k * k + x3) / (1.0 + k * k);
                yt = y1 + (xt - x1) * k;
            }
        } else {
            p = (CPoint)this.points.get(1);
            double x2 = p.getx();
            double y2 = p.gety();
            if (Math.abs(x2 - x1) < 10.0) {
                xt = x1;
                yt = y3;
            } else {
                double xd = x2 - x1;
                double yd = y2 - y1;
                xt = ((y3 - y1) * yd * xd + x1 * yd * yd + x3 * xd * xd) / (xd * xd + yd * yd);
                yt = y1 + (xt - x1) * yd / xd;
            }
        }
        pt.setXY(xt, yt);
    }

    public static CPoint commonPoint(CLine line0, CLine line1) {
        for (int i = 0; i < line0.points.size(); ++i) {
            CPoint p1 = (CPoint)line0.points.get(i);
            for (int j = 0; j < line1.points.size(); ++j) {
                CPoint p2 = (CPoint)line1.points.get(j);
                if (p1 != p2) continue;
                return p1;
            }
        }
        return null;
    }

    public static double[] Intersect(CLine line0, CLine line1) {
        double[] result = new double[2];
        if (line0.isVertical()) {
            if (line1.isVertical()) {
                return null;
            }
            double k = line1.getK();
            CPoint p0 = (CPoint)line0.points.get(0);
            CPoint p1 = (CPoint)line1.points.get(0);
            result[0] = p0.getx();
            result[1] = k * (p0.getx() - p1.getx()) + p1.gety();
            return result;
        }
        if (line1.isVertical()) {
            CPoint p0 = (CPoint)line0.points.get(0);
            CPoint p1 = (CPoint)line0.points.get(1);
            CPoint p = (CPoint)line1.points.get(0);
            double k0 = line0.getK();
            result[0] = p.getx();
            result[1] = k0 * (p0.getx() - p1.getx()) + p1.gety();
            return result;
        }
        CPoint p0 = (CPoint)line0.points.get(0);
        CPoint p1 = (CPoint)line1.points.get(0);
        double k0 = line0.getK();
        double k1 = line1.getK();
        double x = (p1.gety() - p0.gety() + k0 * p0.getx() - k1 * p1.getx()) / (k0 - k1);
        double y = k0 * (x - p0.getx()) + p0.gety();
        result[0] = x;
        result[1] = y;
        return result;
    }

    public void Save(DataOutputStream out) throws IOException {
        int i;
        out.writeInt(this.id);
        this.drawt.Save(out);
        out.writeInt(this.name.length());
        out.writeChars(this.name);
        out.writeInt(this.type);
        out.writeInt(this.points.size());
        for (i = 0; i < this.points.size(); ++i) {
            CPoint p = (CPoint)this.points.get(i);
            out.writeInt(p.id);
        }
        out.writeInt(this.cons.size());
        for (i = 0; i < this.cons.size(); ++i) {
            constraint cs = (constraint)this.cons.get(i);
            out.writeInt(cs.id);
        }
    }

    public void Load(DataInputStream in, drawProcess dp) throws IOException {
        int d;
        int i;
        this.id = in.readInt();
        this.drawt = new drawType();
        this.drawt.Load(in);
        this.name = new String();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            this.name = this.name + in.readChar();
        }
        this.type = in.readInt();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            d = in.readInt();
            this.points.add(dp.getPointById(d));
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            d = in.readInt();
            this.cons.add(dp.getConstraintByid(d));
        }
    }
}

