/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import wprover.CMisc;
import wprover.constraint;
import wprover.drawData;
import wprover.drawProcess;
import wprover.drawType;
import wprover.param;

public class CPoint {
    int id = CMisc.id_count++;
    drawType drawt = null;
    String name = "";
    int type = 0;
    param x1;
    param y1;
    int OnCircleOrOnLine = 0;
    Vector cons = new Vector();
    boolean visible = true;

    public CPoint() {
    }

    public CPoint(String Name, param X, param Y) {
        this.name = Name;
        this.x1 = X;
        this.y1 = Y;
    }

    public CPoint(param X, param Y, int type) {
        this.x1 = X;
        this.y1 = Y;
        this.type = type;
    }

    public CPoint(param X, param Y) {
        this.x1 = X;
        this.y1 = Y;
    }

    public CPoint(String n) {
        this.name = n;
    }

    public void addcstoPoint(constraint cs) {
        if (!this.cons.contains(cs)) {
            this.cons.add(cs);
        }
    }

    public boolean isEqual(CPoint p) {
        return p.x1 == this.x1 && p.y1 == this.y1;
    }

    public boolean isEqual(int x, int y) {
        return x == this.x1.xindex && y == this.y1.xindex;
    }

    public double getx() {
        if (this.x1 == null) {
            System.out.println("CPoint error,x1 undefined");
            return -1.0;
        }
        return this.x1.value;
    }

    public double gety() {
        if (this.y1 == null) {
            System.out.println("CPoint error,y1 undefined");
            return -1.0;
        }
        return this.y1.value;
    }

    public void setXY(double x, double y) {
        this.x1.value = x;
        this.y1.value = y;
    }

    public void draw() {
        System.out.println("A CPoint");
    }

    public void setFillColor(int index) {
        this.drawt.setColorIndex(index);
    }

    public drawType getDrawType() {
        if (this.drawt != null) {
            return this.drawt;
        }
        int type = this.x1.Solved && this.y1.Solved ? 2 : (!this.x1.Solved && !this.y1.Solved ? 0 : 1);
        this.drawt = drawData.getPointFillType(type);
        return this.drawt;
    }

    public void Save(DataOutputStream out) throws IOException {
        out.writeInt(this.id);
        if (this.drawt == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            this.drawt.Save(out);
        }
        int len = this.name.length();
        out.writeInt(len);
        out.writeChars(this.name);
        out.writeInt(this.type);
        out.writeInt(this.x1.xindex);
        out.writeInt(this.y1.xindex);
        out.writeInt(this.OnCircleOrOnLine);
        int size = this.cons.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            constraint cs = (constraint)this.cons.get(i);
            out.writeInt(cs.id);
        }
        out.writeBoolean(this.visible);
    }

    public void Load(DataInputStream in, drawProcess dp) throws IOException {
        this.id = in.readInt();
        if (in.readInt() == 0) {
            this.drawt = null;
        } else {
            this.drawt = new drawType();
            this.drawt.Load(in);
        }
        int len = in.readInt();
        this.name = new String();
        for (int i = 0; i < len; ++i) {
            this.name = this.name + in.readChar();
        }
        this.type = in.readInt();
        int ix = in.readInt();
        this.x1 = dp.getParameterByindex(ix);
        int iy = in.readInt();
        this.y1 = dp.getParameterByindex(iy);
        this.OnCircleOrOnLine = in.readInt();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            int id = in.readInt();
            this.cons.add(dp.getConstraintByid(id));
        }
        this.visible = in.readBoolean();
    }
}

