/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import wprover.CMisc;
import wprover.CPoint;
import wprover.drawData;
import wprover.drawProcess;
import wprover.drawType;

public class CPolygon {
    int id = CMisc.id_count++;
    Vector pointlist = new Vector();
    drawType drawt = drawData.getCurrentFillType();

    public boolean addAPoint(CPoint p) {
        this.pointlist.add(p);
        return this.pointlist.size() > 1 && p == this.pointlist.get(0);
    }

    public void draw(Graphics2D g2) {
        int i;
        int n = this.pointlist.size();
        if (n == 0) {
            return;
        }
        if (this.pointlist.get(0) != this.pointlist.get(n - 1)) {
            return;
        }
        int[] xpoints = new int[n];
        int[] ypoints = new int[n];
        for (i = 0; i < n; ++i) {
            CPoint pt = (CPoint)this.pointlist.get(i);
            xpoints[i] = (int)pt.getx();
            ypoints[i] = (int)pt.gety();
        }
        this.drawt.setdrawType(g2);
        for (i = 1; i < n; ++i) {
            g2.drawLine(xpoints[i - 1], ypoints[i - 1], xpoints[i], ypoints[i]);
        }
        g2.drawLine(xpoints[0], ypoints[0], xpoints[n - 1], ypoints[n - 1]);
        g2.fillPolygon(xpoints, ypoints, n);
    }

    public boolean isCatch(CPoint p) {
        Polygon poly = new Polygon();
        for (int i = 0; i < this.pointlist.size(); ++i) {
            CPoint pt = (CPoint)this.pointlist.get(i);
            poly.addPoint((int)pt.getx(), (int)pt.gety());
        }
        return poly.contains(p.getx(), p.gety());
    }

    public void draw(Graphics2D g2, CPoint p) {
        if (this.pointlist.size() == 0) {
            return;
        }
        int n = this.pointlist.size() + 2;
        int[] xpoints = new int[n];
        int[] ypoints = new int[n];
        for (int i = 0; i < this.pointlist.size(); ++i) {
            CPoint pt = (CPoint)this.pointlist.get(i);
            xpoints[i] = (int)pt.getx();
            ypoints[i] = (int)pt.gety();
        }
        xpoints[n - 2] = (int)p.getx();
        ypoints[n - 2] = (int)p.gety();
        CPoint pt = (CPoint)this.pointlist.get(0);
        xpoints[n - 1] = (int)pt.getx();
        ypoints[n - 1] = (int)pt.gety();
        this.drawt.setdrawType(g2);
        g2.fillPolygon(xpoints, ypoints, n);
        g2.setColor(Color.yellow);
        for (int i = 1; i < n; ++i) {
            g2.drawLine(xpoints[i - 1], ypoints[i - 1], xpoints[i], ypoints[i]);
        }
        g2.drawLine(xpoints[0], ypoints[0], xpoints[n - 1], ypoints[n - 1]);
        g2.drawLine(xpoints[0], ypoints[0], (int)p.getx(), (int)p.gety());
        g2.drawLine(xpoints[n - 1], ypoints[n - 1], (int)p.getx(), (int)p.gety());
    }

    public void Save(DataOutputStream out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.pointlist.size());
        for (int i = 0; i < this.pointlist.size(); ++i) {
            CPoint p = (CPoint)this.pointlist.get(i);
            out.writeInt(p.id);
        }
        this.drawt.Save(out);
    }

    public void Load(DataInputStream in, drawProcess dp) throws IOException {
        this.id = in.readInt();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            int d = in.readInt();
            this.pointlist.add(dp.getPointById(d));
        }
        this.drawt = new drawType();
        this.drawt.Load(in);
    }
}

