/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import wprover.CMisc;
import wprover.drawData;
import wprover.drawProcess;

public class CText {
    int id = CMisc.id_count++;
    int x;
    int y;
    String str;
    Font font;
    int color = drawData.getColorIndex(Color.black);
    double w;
    double h;
    double height;

    public CText() {
    }

    public CText(String s) {
        this.y = 50;
        this.x = 50;
        this.str = s;
        this.font = new Font("Dialog", 0, 14);
    }

    public CText(String s, Font f) {
        this.str = s;
        this.font = f;
    }

    public CText(int x, int y, String s) {
        this.str = s;
        this.font = new Font("Dialog", 0, 14);
        this.x = x;
        this.y = y;
    }

    public void draw(Graphics2D g2) {
        if (this.str.length() == 0) {
            return;
        }
        String[] sl = this.str.split("\n");
        g2.setFont(this.font);
        g2.setColor(drawData.getColor(this.color));
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = g2.getFont();
        LineMetrics lm = f.getLineMetrics(sl[0], frc);
        this.h = lm.getHeight();
        this.height = this.h * (double)sl.length;
        this.w = 0.0;
        for (int i = 0; i < sl.length; ++i) {
            Rectangle2D r2 = f.getStringBounds(sl[i], frc);
            if (r2.getWidth() > this.w) {
                this.w = r2.getWidth();
            }
            g2.drawString(sl[i], (float)this.x, (float)((double)this.y + (double)(i + 1) * this.h));
        }
    }

    public void draw(Graphics2D g2, boolean select) {
        g2.setColor(drawData.getColor(this.color));
        this.draw(g2);
        g2.setColor(Color.pink);
        g2.draw(new Rectangle(this.x - 1, this.y, (int)this.w + 2, (int)this.height + 2));
    }

    public boolean isCatch(double x1, double y1) {
        double dx = x1 - (double)this.x;
        double dy = y1 - (double)this.y;
        return dx > 0.0 && dx < this.w && dy > 0.0 && dy < this.height;
    }

    public void drag(double dx, double dy) {
        this.x = (int)((double)this.x + dx);
        this.y = (int)((double)this.y + dy);
    }

    public void Save(DataOutputStream out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.x);
        out.writeInt(this.y);
        byte[] s = this.str.getBytes();
        out.writeInt(s.length);
        out.write(s, 0, s.length);
        s = this.font.getName().getBytes();
        out.writeInt(s.length);
        out.write(s, 0, s.length);
        out.writeInt(this.font.getStyle());
        out.writeInt(this.font.getSize());
        out.writeInt(this.color);
    }

    public void Load(DataInputStream in, drawProcess dp) throws IOException {
        this.id = in.readInt();
        this.x = in.readInt();
        this.y = in.readInt();
        int size = in.readInt();
        byte[] s = new byte[size];
        in.read(s, 0, size);
        this.str = new String(s);
        if (CMisc.version_load_now >= 0.005) {
            int n = in.readInt();
            byte[] str = new byte[n];
            in.read(str, 0, n);
            String name = new String(str);
            int type = in.readInt();
            int sz = in.readInt();
            int rgb = in.readInt();
            this.font = new Font(name, type, sz);
            this.color = CMisc.version_load_now == 0.006 ? (rgb <= 0 ? drawData.getColorIndex(Color.black) : rgb) : (rgb < 0 ? drawData.getColorIndex(Color.black) : rgb);
        }
    }
}

