/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import wprover.CLine;
import wprover.CMisc;
import wprover.CPoint;
import wprover.constraint;
import wprover.drawData;
import wprover.drawProcess;
import wprover.drawType;

public class Circle {
    public static int PCircle = 0;
    public static int RCircle = 1;
    int id = CMisc.id_count++;
    drawType drawt = drawData.getCurrentDrawType();
    int type = PCircle;
    String name = null;
    CPoint o = new CPoint();
    Vector points = new Vector();
    Vector cons = new Vector();

    public void setType(int type) {
        this.type = type;
    }

    public String getAllPointName() {
        String s = new String();
        for (int i = 0; i < this.points.size(); ++i) {
            CPoint p = (CPoint)this.points.get(i);
            s = i == 0 ? s + p.name : s + ", " + p.name;
        }
        return s;
    }

    public CPoint getSidePoint() {
        CPoint pt = null;
        for (int i = 0; i < this.points.size(); ++i) {
            CPoint p = (CPoint)this.points.get(i);
            if (pt == null) {
                pt = p;
                continue;
            }
            if (pt.x1.xindex <= p.x1.xindex) continue;
            pt = p;
        }
        return pt;
    }

    public double getRadius() {
        if (this.type == RCircle) {
            Object cs = null;
            for (int i = 0; i < this.cons.size(); ++i) {
                constraint c = (constraint)this.cons.get(i);
                if (c.GetConstraintType() != 20) continue;
                CPoint p1 = (CPoint)c.getelement(0);
                CPoint p2 = (CPoint)c.getelement(1);
                return Math.sqrt(Math.pow(p1.getx() - p2.getx(), 2.0) + Math.pow(p1.gety() - p2.gety(), 2.0));
            }
            return -1.0;
        }
        CPoint p = this.getSidePoint();
        return Math.sqrt(Math.pow(p.getx() - this.o.getx(), 2.0) + Math.pow(p.gety() - this.o.gety(), 2.0));
    }

    public CPoint[] getRadiusPoint() {
        CPoint[] pl = new CPoint[2];
        if (this.type == RCircle) {
            for (int i = 0; i < this.cons.size(); ++i) {
                constraint cs = (constraint)this.cons.get(i);
                if (cs.GetConstraintType() != 20) continue;
                pl[0] = (CPoint)cs.getelement(0);
                pl[1] = (CPoint)cs.getelement(1);
                return pl;
            }
        } else if (this.type == PCircle) {
            pl[0] = this.o;
            pl[1] = this.getSidePoint();
        }
        return pl;
    }

    public Circle() {
    }

    public Circle(CPoint O, CPoint A, CPoint B, CPoint C) {
        this.o = O;
        this.points.add(A);
        this.points.add(B);
        this.points.add(C);
        C.OnCircleOrOnLine = 2;
        B.OnCircleOrOnLine = 2;
        A.OnCircleOrOnLine = 2;
    }

    public Circle(CPoint O, CPoint A, CPoint B) {
        this.o = O;
        this.points.add(A);
        this.points.add(B);
        B.OnCircleOrOnLine = 2;
        A.OnCircleOrOnLine = 2;
    }

    public Circle(CPoint O, CPoint A) {
        this.o = O;
        this.points.add(A);
        A.OnCircleOrOnLine = 2;
    }

    public Circle(int type, CPoint O) {
        this.o = O;
        this.type = type;
    }

    public void addConstraint(constraint cs) {
        this.cons.add(cs);
    }

    public boolean hasPoint(CPoint p) {
        for (int i = 0; i < this.points.size(); ++i) {
            if (!p.isEqual((CPoint)this.points.get(i))) continue;
            return true;
        }
        return false;
    }

    public void addPoint(CPoint p) {
        if (!this.points.contains(p)) {
            this.points.add(p);
        }
        p.OnCircleOrOnLine = 2;
    }

    public boolean nearcircle(CPoint p, double eps) {
        double len;
        double ox = this.o.getx();
        double oy = this.o.gety();
        double x = p.getx();
        double y = p.gety();
        double r = this.getRadius();
        return Math.abs(r - (len = Math.sqrt(Math.pow(x - ox, 2.0) + Math.pow(y - oy, 2.0)))) < eps;
    }

    public void SmartPonc(CPoint p) {
        double ox = this.o.getx();
        double oy = this.o.gety();
        double x = p.getx();
        double y = p.gety();
        double r = this.getRadius();
        double len = Math.sqrt(Math.pow(p.getx() - ox, 2.0) + Math.pow(p.gety() - oy, 2.0));
        if (Math.abs(x - this.o.getx()) < 0.001) {
            if (y > oy) {
                p.setXY(ox, oy + r);
            } else {
                p.setXY(ox, oy - r);
            }
        } else {
            double k = r / len;
            p.setXY(ox + k * (x - ox), oy + k * (y - oy));
        }
    }

    public boolean Tangent(Object obj) {
        if (obj instanceof CLine) {
            return true;
        }
        if (obj instanceof Circle) {
            double d;
            double r2;
            Circle c2 = (Circle)obj;
            CPoint p1 = this.getSidePoint();
            CPoint p2 = c2.getSidePoint();
            double r1 = Math.sqrt(Math.pow(this.o.getx() - p1.getx(), 2.0) + Math.pow(this.o.gety() - p1.gety(), 2.0));
            return Math.abs(r1 + (r2 = Math.sqrt(Math.pow(c2.o.getx() - p2.getx(), 2.0) + Math.pow(c2.o.gety() - p2.gety(), 2.0))) - (d = Math.sqrt(Math.pow(this.o.getx() - c2.o.getx(), 2.0) + Math.pow(this.o.gety() - c2.o.gety(), 2.0)))) < 5.0;
        }
        return false;
    }

    public void draw() {
        System.out.println("a circle");
    }

    public void Save(DataOutputStream out) throws IOException {
        int i;
        out.writeInt(this.id);
        this.drawt.Save(out);
        out.writeInt(this.type);
        out.writeInt(this.name.length());
        out.writeChars(this.name);
        out.writeInt(this.o.id);
        out.writeInt(this.points.size());
        for (i = 0; i < this.points.size(); ++i) {
            CPoint p = (CPoint)this.points.get(i);
            out.writeInt(p.id);
        }
        out.writeInt(this.cons.size());
        for (i = 0; i < this.cons.size(); ++i) {
            constraint cs = (constraint)this.cons.get(i);
            out.writeInt(cs.id);
        }
    }

    public void Load(DataInputStream in, drawProcess dp) throws IOException {
        int dx;
        int i;
        this.id = in.readInt();
        this.drawt = new drawType();
        this.drawt.Load(in);
        this.type = in.readInt();
        int size = in.readInt();
        this.name = new String();
        for (int i2 = 0; i2 < size; ++i2) {
            this.name = this.name + in.readChar();
        }
        int d = in.readInt();
        this.o = dp.getPointById(d);
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            dx = in.readInt();
            this.points.add(dp.getPointById(dx));
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            dx = in.readInt();
            this.cons.add(dp.getConstraintByid(dx));
        }
    }
}

