/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import wprover.drawData;

class ColorComboRender
extends JPanel
implements ListCellRenderer,
TableCellRenderer {
    int type;
    int width;
    int height;
    int index = 0;
    boolean select = false;

    public ColorComboRender(int type, int w, int h) {
        this.setOpaque(true);
        this.type = type;
        this.width = w;
        this.height = h;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int selectedIndex = value != null ? (Integer)value : 0;
        this.select = isSelected;
        this.index = selectedIndex;
        return this;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.select) {
            g2.setBackground(Color.lightGray);
        } else {
            g2.setBackground(Color.white);
        }
        g2.clearRect(0, 0, this.width, this.height);
        this.setFont(new Font("Arial", 0, 12));
        int w = 2 * this.height / 5;
        int gap = this.height / 5;
        if (this.type == 0) {
            if (this.index < drawData.getColorCounter() && this.index >= 0) {
                g2.setColor(drawData.getColor(this.index));
                g2.fillRect(gap, gap, gap + w, gap + w);
                g2.setColor(Color.black);
                g2.drawRect(gap, gap, gap + w, gap + w);
                g2.drawString(drawData.getColorName(this.index), this.height * 2, this.height - gap);
            } else if (this.index == drawData.getColorCounter()) {
                int w2 = w / 2 + 2;
                g2.setColor(Color.red);
                g2.fillRect(gap, gap, w2, w2);
                g2.setColor(Color.green);
                g2.fillRect(gap, gap + w2, w2, w2);
                g2.setColor(Color.blue);
                g2.fillRect(gap + w2, gap, w2, w2);
                g2.setColor(Color.yellow);
                g2.fillRect(gap + w2, gap + w2, w2, w2);
                g2.setColor(Color.black);
                g2.drawRect(gap, gap, gap + w, gap + w);
                g2.drawString("Other", this.height * 2, this.height - gap);
            }
        } else if (this.type == 1) {
            float ww = (float)drawData.getWidth(this.index);
            g2.setStroke(new BasicStroke(ww));
            g2.setColor(Color.black);
            g2.drawLine(5, this.height / 2, this.width * 2 / 5, this.height / 2);
            g2.drawString("" + ww, this.width / 2, this.height / 2);
        } else if (this.type == 2) {
            float ds = 0.0f;
            if (this.index <= 0) {
                g2.setStroke(new BasicStroke(1.0f));
            } else {
                ds = (float)drawData.getDash(this.index);
                float[] dash = new float[]{ds};
                g2.setStroke(new BasicStroke(0.2f, 0, 0, 5.0f, dash, 0.0f));
            }
            g2.setColor(Color.black);
            g2.drawLine(5, this.height / 2, this.width * 2 / 5, this.height / 2);
            if (this.index <= 0) {
                g2.drawString("solid", this.width / 2, this.height / 2);
            } else {
                g2.drawString("" + ds, this.width / 2, this.height / 2);
            }
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.select = isSelected;
        return this;
    }
}

