/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import wprover.CAngle;
import wprover.CDistance;
import wprover.CLine;
import wprover.CPoint;
import wprover.CharSet;
import wprover.Circle;
import wprover.GExpert;
import wprover.GeoPoly;
import wprover.TMono;
import wprover.TPoly;
import wprover.drawProcess;

public class ConclutionFrame
extends JFrame
implements ItemListener,
ActionListener,
WindowListener {
    private static GeoPoly poly = GeoPoly.getPoly();
    private static CharSet charset = CharSet.getinstance();
    JPanel pinf;
    String[] msg = new String[]{" select four points", " select four points", " select three points", " select three points", " select two angles", " select two distance", " select two circles ", " select a line and a circle"};
    JRadioButton parel;
    JRadioButton perp;
    JRadioButton collinear;
    JRadioButton mid;
    JRadioButton eqangle;
    JRadioButton eqdis;
    JRadioButton cctangent;
    JRadioButton lctangent;
    JLabel label;
    public static JTextPane field;
    public static ConclutionFrame cf;
    JButton pbutton = new JButton("Prove");
    int type = -1;

    public ConclutionFrame(drawProcess dp) {
        cf = this;
        this.setTitle("Conclusion");
        Dimension VD = new Dimension(15, 40);
        Dimension HD = new Dimension(40, 15);
        JPanel panelAll = new JPanel();
        panelAll.setLayout(new BoxLayout(panelAll, 0));
        panelAll.add(Box.createRigidArea(VD));
        JPanel innerPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width, super.getMaximumSize().height);
            }
        };
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        panelAll.add(innerPanel);
        panelAll.add(Box.createRigidArea(VD));
        this.parel = new JRadioButton("parallel");
        this.perp = new JRadioButton("perpedicular");
        this.collinear = new JRadioButton("collinear");
        this.mid = new JRadioButton("middle point");
        this.eqangle = new JRadioButton("equal angle");
        this.eqdis = new JRadioButton("equal distance");
        this.cctangent = new JRadioButton("CC Tangent");
        this.lctangent = new JRadioButton("LC Tangent");
        ButtonGroup bg = new ButtonGroup();
        innerPanel.add(this.parel);
        bg.add(this.parel);
        this.parel.addItemListener(this);
        innerPanel.add(this.perp);
        bg.add(this.perp);
        this.perp.addItemListener(this);
        innerPanel.add(this.collinear);
        bg.add(this.collinear);
        this.collinear.addItemListener(this);
        innerPanel.add(this.mid);
        bg.add(this.mid);
        this.mid.addItemListener(this);
        innerPanel.add(this.eqangle);
        bg.add(this.eqangle);
        this.eqangle.addItemListener(this);
        innerPanel.add(this.eqdis);
        bg.add(this.eqdis);
        this.eqdis.addItemListener(this);
        innerPanel.add(this.cctangent);
        bg.add(this.cctangent);
        this.cctangent.addItemListener(this);
        innerPanel.add(this.lctangent);
        bg.add(this.lctangent);
        this.lctangent.addItemListener(this);
        this.label = new JLabel();
        innerPanel.add(Box.createRigidArea(new Dimension(40, 30)));
        innerPanel.add(new JLabel("Conclusion: "));
        innerPanel.add(this.label);
        innerPanel.add(Box.createRigidArea(HD));
        innerPanel.add(this.pbutton);
        innerPanel.add(Box.createRigidArea(HD));
        this.setSize(800, 600);
        this.SetStatus();
        field = new JTextPane();
        JScrollPane spane = new JScrollPane(field);
        spane.setSize(200, 300);
        this.getContentPane().add((Component)spane, "Center");
        this.pinf = new JPanel();
        this.pinf.setSize(200, 400);
        this.pbutton.addActionListener(this);
        this.getContentPane().add((Component)panelAll, "Before");
        panelAll.add(this.pinf);
        this.setLocation(300, 200);
        this.addWindowListener(this);
    }

    public boolean SetStatus() {
        Vector list = GExpert.d.dp.getSelectList();
        int np = 0;
        int nl = 0;
        int nc = 0;
        int ng = 0;
        int nd = 0;
        String[] sl = new String[4];
        int index = 0;
        if (list.size() > 4) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof CPoint) {
                sl[index] = ((CPoint)obj).name;
                ++np;
            } else if (obj instanceof CLine) {
                sl[index] = ((CLine)obj).name;
                ++nl;
            } else if (obj instanceof Circle) {
                sl[index] = ((Circle)obj).name;
                ++nc;
            } else if (obj instanceof CAngle) {
                sl[index] = ((CAngle)obj).getDescription();
                ++ng;
            } else if (obj instanceof CDistance) {
                CDistance cd = (CDistance)obj;
                sl[index] = "|" + cd.pstart.name + cd.pend.name + "|";
                ++nd;
            }
            ++index;
        }
        boolean is = false;
        if (nc == 0 && ng == 0 && nl == 0 && np == 0 && this.type != -1) {
            this.label.setText(this.msg[this.type]);
        }
        String lb = null;
        if (nc == 0 && ng == 0 && nl == 0) {
            if (np == 3) {
                if (this.type == 3) {
                    is = true;
                    lb = "Point " + sl[0] + " is the center of " + sl[1] + " and " + sl[2];
                } else if (this.type == 5) {
                    is = true;
                    lb = "|" + sl[0] + sl[1] + "| = |" + sl[1] + sl[2] + "|";
                } else if (this.type == 2) {
                    is = true;
                    lb = sl[0] + "," + sl[1] + "," + sl[2] + " are collinear";
                }
            }
            if (np == 4) {
                is = true;
                if (this.type == 0) {
                    lb = sl[0] + sl[1] + " parallel to " + sl[2] + sl[3];
                } else if (this.type == 1) {
                    lb = sl[0] + sl[1] + " perpedicular to " + sl[2] + sl[3];
                } else if (this.type == 5) {
                    lb = sl[0] + sl[1] + "| = |" + sl[2] + sl[3] + "|";
                } else {
                    is = false;
                }
            }
        } else if (np == 0 && nl == 0 && nc == 0) {
            if (ng == 2 && this.type == 4) {
                lb = sl[0] + "equal to " + sl[1];
                is = true;
            }
        } else if (np == 0 && ng == 0 && nd == 0) {
            if (this.type == 7 && nl == 1 && nc == 1) {
                lb = sl[0] + " tangent to " + sl[1];
                is = true;
            } else if (nc == 2 && this.type == 6) {
                lb = sl[0] + " tangent to Circle " + sl[1];
                is = true;
            }
        }
        this.label.setText(lb);
        if (is) {
            this.pbutton.setEnabled(true);
        } else {
            this.pbutton.setEnabled(false);
        }
        return is;
    }

    public void itemStateChanged(ItemEvent e) {
        this.type = this.parel.isSelected() ? 0 : (this.perp.isSelected() ? 1 : (this.collinear.isSelected() ? 2 : (this.mid.isSelected() ? 3 : (this.eqangle.isSelected() ? 4 : (this.eqdis.isSelected() ? 5 : (this.cctangent.isSelected() ? 6 : (this.lctangent.isSelected() ? 7 : -1)))))));
        if (!this.SetStatus() && this.type != -1) {
            this.label.setText(this.msg[this.type]);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Vector vl = GExpert.d.dp.getSelectList();
        Object plist = null;
        int type = 0;
        Object[] obj = new Object[4];
        if (e.getActionCommand().compareTo("Prove") == 0) {
            type = this.parel.isSelected() ? 2 : (this.perp.isSelected() ? 3 : (this.collinear.isSelected() ? 1 : (this.mid.isSelected() ? 6 : (this.eqangle.isSelected() ? 7 : (this.eqdis.isSelected() ? 4 : (this.cctangent.isSelected() ? 10 : (this.lctangent.isSelected() ? 9 : 0)))))));
        }
        ConclutionFrame.runc(type);
    }

    public void windowClosed(WindowEvent e) {
        boolean i = false;
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
        boolean t = this.SetStatus();
    }

    public void windowDeactivated(WindowEvent e) {
        boolean i = false;
    }

    public void windowClosing(WindowEvent e) {
        StyledDocument doc = field.getStyledDocument();
        try {
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException ble) {
            System.out.println("Could not clear the result of conclusion");
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prove(int type) {
        int i;
        Vector vl = GExpert.d.dp.getSelectList();
        TPoly plist = null;
        Object[] obj = new Object[4];
        for (i = 0; i < 4; ++i) {
            obj[i] = null;
        }
        for (i = 0; i < vl.size(); ++i) {
            obj[i] = vl.get(i);
        }
        plist = type == 4 && vl.size() == 3 ? GExpert.d.dp.add_cons_or_conclution(type, obj[0], obj[1], obj[1], obj[2]) : GExpert.d.dp.add_cons_or_conclution(type, obj[0], obj[1], obj[2], obj[3]);
        TPoly pclist = GExpert.d.dp.getCopyPolyBacklist();
        pclist = poly.OptimizePoly(pclist);
        plist = poly.OptimizePoly(plist);
        pclist = charset.charset(pclist);
        pclist = charset.reverse(pclist);
        TMono tp = plist.getPoly();
        int i2 = 0;
        for (TPoly tl = pclist; tl != null; tl = tl.getNext()) {
            ++i2;
        }
        int n = i2;
        StyledDocument doc = field.getStyledDocument();
        int result = -1;
        try {
            doc.insertString(doc.getLength(), "Step 1 convert the geometric conditions into polynomial form: \n" + GExpert.d.dp.getPolyString(0), doc.getStyle("small"));
            doc.insertString(doc.getLength(), "The conclusion polynomial is: \nc = " + poly.pirntSPoly(tp) + "\n", doc.getStyle("small"));
            doc.insertString(doc.getLength(), "Step 2 Transform the hypothesis polynomial set into trianguar form:\n" + GExpert.d.dp.getPolyString(1), doc.getStyle("small"));
            doc.insertString(doc.getLength(), "\nStep 3 Successive Pseudo Division:\nLet R_" + n + " = c (the conclusion polynomial)\n", doc.getStyle("small"));
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
        try {
            long time = System.currentTimeMillis();
            while (pclist != null) {
                ConclutionFrame conclutionFrame = cf;
                synchronized (conclutionFrame) {
                    tp = poly.prem(tp, pclist.getPoly());
                    long t = System.currentTimeMillis() - time;
                    doc.insertString(doc.getLength(), "Length of R_" + (i2 - 1) + " = prem(R_" + i2 + ", f_" + (i2 - 1) + ") =  " + poly.plength(tp) + "\t\ttime = " + (float)t / 1000.0f + '\n', doc.getStyle("small"));
                    --i2;
                    pclist = pclist.getNext();
                }
            }
            time = System.currentTimeMillis() - time;
            result = poly.plength(tp);
            doc.insertString(doc.getLength(), "\nStep 4 check the final remainder:", doc.getStyle("small"));
            if (result == 0) {
                doc.insertString(doc.getLength(), "Since the final remainder R0 is zero, and we have\n   the following remainder formula for successive pseudo division:\n\n     I0^s0 I1^s1 ... I" + n + "^s" + n + " c = Q0 f0 + Q1 f1 + ... + Q" + n + " f" + n + " + R0\n" + "\nthe conclusion polynomial c must be 0 " + "if all the I_i are not zero." + "\nThe " + " theorem is proved under non-degenerate conditions " + "\n\n     I_0 != 0, ..., I_" + n + " != 0\n\n" + "where I_i is the leading coefficient of  f_i." + "used time =  " + (double)time / 1000.0 + " seconds \n" + "\n\nFor an elemntary exposition of the underlying" + " theory see Chou's 1984 paper included in this CD " + "distribution.\n Also see Chou and Gao's paper " + "'A Class of Geometry Statements of Constructive " + "Type and Geometry Theorem Proving', " + "TR-89-37, CS department, UT, Austin, 1989. QED.\n" + "* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n", doc.getStyle("small"));
            } else {
                doc.insertString(doc.getLength(), "since the final remainder R_" + i2 + " is not zero,\n" + "the statement is not confirmed\n", doc.getStyle("small"));
                doc.insertString(doc.getLength(), "The remain polynomial is: \nc = " + poly.pirntSPoly(tp) + "\n", doc.getStyle("small"));
            }
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
        if (result == 0) {
            GExpert.d.dp.add_conclution_object(type, obj[0], obj[1], obj[2]);
        }
    }

    public static void runc(final int type) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConclutionFrame.prove(type);
            }
        });
    }
}

