/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import wprover.CAsistLine;
import wprover.CBackup;
import wprover.CCoBox;
import wprover.CLine;
import wprover.CMisc;
import wprover.CPoint;
import wprover.CTransform;
import wprover.Circle;
import wprover.GExpert;
import wprover.SClass;
import wprover.drawProcess;
import wprover.mainProcess;

class DPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int DRAW = 0;
    public static final int PROVE = 1;
    JPopupMenu popup;
    JPopupMenu basicPopup;
    BufferedImage bi;
    Graphics2D big;
    mainProcess mp = new mainProcess();
    drawProcess dp = new drawProcess();
    private int Input_type = 0;

    public void SetInputType(int type) {
        this.Input_type = type;
    }

    public void SetDrawType(int type) {
        this.Input_type = 0;
        this.dp.SetCurrentAction(type);
    }

    public void Clear() {
        if (this.Input_type == 0) {
            CCoBox.resetAll();
            this.dp.clearAll();
            GExpert ge = GExpert.gexInstance;
            ge.setTitle("GExpert" + CMisc.version);
        }
        this.repaint();
    }

    public void setStep(double step) {
        this.dp.animate.Setstep(step);
    }

    private void CreateBasicPopupMenu(JPopupMenu menu) {
        for (int i = 0; i < SClass.BasicPopupMenu.length; ++i) {
            String[] text = SClass.BasicPopupMenu[i];
            if (text[1].compareTo("Separator") == 0) {
                menu.addSeparator();
                continue;
            }
            JMenuItem menuItem = new JMenuItem(text[1]);
            menuItem.setActionCommand(text[0]);
            menuItem.setToolTipText(text[2]);
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
    }

    public DPanel() {
        this.setBackground(Color.white);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.basicPopup = new JPopupMenu();
        this.popup = new JPopupMenu();
        this.CreateBasicPopupMenu(this.popup);
        this.bi = new BufferedImage(5, 5, 1);
        this.big = this.bi.createGraphics();
        this.big.setColor(Color.white);
        this.big.dispose();
    }

    public void StartProve(String name) {
        this.Input_type = 1;
        if (!this.mp.setvarable(name)) {
            this.repaint();
            return;
        }
        this.mp.generate();
        this.mp.SetAttr();
        this.mp.firstTime = 1;
    }

    public void ReadingInput(String name) {
        this.mp.fN = name;
        this.mp.read_input();
    }

    public void onAnimate(int type) {
        if (type == 1) {
            this.dp.animationStart();
        } else if (type == 2) {
            this.dp.animationStop();
        } else if (type == 0) {
            this.dp.animationOntime();
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        int button = e.getButton();
        if (button == 3) {
            return;
        }
        if (this.Input_type == 0) {
            int buttonType = e.getButton();
            this.dp.DWButtonDown(e.getX(), e.getY());
            this.repaint();
        } else {
            double y;
            CTransform trans = this.mp.gettrans();
            double x = trans.transWLX(e.getX(), e.getY());
            if (!this.mp.isNear(x, y = trans.transWLY(e.getX(), e.getY()))) {
                this.mp.updateLocation(x, y);
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        int button = e.getButton();
        if (button == 3) {
            return;
        }
        if (this.Input_type == 0) {
            this.dp.DWMouseDrag(e.getX(), e.getY());
            this.repaint();
        } else {
            CTransform trans = this.mp.gettrans();
            double x = trans.transWLX(e.getX(), e.getY());
            double y = trans.transWLY(e.getX(), e.getY());
            this.mp.updateLocation(x, y);
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        int button = e.getButton();
        if (button == 3) {
            return;
        }
        if (this.Input_type == 0) {
            this.dp.DWButtonUp(e.getX(), e.getY());
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        int button = e.getButton();
        if (button == 3) {
            return;
        }
        if (this.Input_type == 0) {
            this.dp.DWMouseMove(e.getX(), e.getY());
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.dp.DWMouseClick(e.getX(), e.getY());
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        boolean i = false;
    }

    public void keyReleased(KeyEvent e) {
        boolean i = false;
    }

    public void setActionTip(String name, String tip) {
        int i;
        char[] sc = new char[30];
        char[] sname = name.toCharArray();
        for (i = 0; i < 30; ++i) {
            sc[i] = 32;
        }
        for (i = 0; i < sname.length; ++i) {
            sc[i] = sname[i];
        }
        String s = new String(sc);
        GExpert.label.setText(s + tip);
    }

    public void actionPerformed(ActionEvent e) {
        block126: {
            JFileChooser chooser;
            String name;
            String command = e.getActionCommand();
            Object src = e.getSource();
            String tip = null;
            String ps = null;
            String pname = null;
            if (src instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)src;
                ps = item.getText();
                tip = item.getToolTipText();
                pname = item.getName();
            } else if (src instanceof JButton) {
                JButton button = (JButton)src;
                button.setSelected(true);
                ps = button.getText();
                tip = button.getToolTipText();
            }
            this.setActionTip(command, tip);
            if (command.compareTo("men_example") == 0) {
                try {
                    String sp = System.getProperty("file.separator");
                    this.dp = new drawProcess();
                    this.dp.name = ps;
                    boolean ss = this.dp.Load(pname + sp + ps + ".gex");
                    GExpert ge = GExpert.gexInstance;
                    if (ss) {
                        ge.setTitle("GExpert" + CMisc.version + "             " + ps);
                        break block126;
                    }
                    ge.setTitle("GExpert" + CMisc.version);
                }
                catch (IOException ee) {
                    System.out.println(ee.toString() + "\n" + ee.getStackTrace());
                }
            } else if (command.compareTo("recent_example") == 0) {
                CBackup.Load(ps);
            } else if (command.compareTo("select") == 0) {
                this.SetDrawType(0);
            } else if (command.compareTo("point") == 0) {
                this.SetDrawType(1);
            } else if (command.compareTo("line") == 0) {
                this.SetDrawType(2);
            } else if (command.compareTo("circle") == 0) {
                this.SetDrawType(9);
            } else if (command.compareTo("oriented segment") == 0) {
                name = ((JMenuItem)e.getSource()).getText();
                if (name.compareTo("1 : 2") == 0) {
                    this.dp.SetActionWithPropotion(31, 2);
                } else if (name.compareTo("2 : 1") == 0) {
                    this.dp.SetActionWithPropotion(31, -2);
                } else {
                    this.dp.SetActionWithPropotion(31, 1);
                }
            } else if (command.compareTo("circler") == 0) {
                this.SetDrawType(28);
            } else if (command.compareTo("parallel") == 0) {
                this.SetDrawType(3);
            } else if (command.compareTo("perp") == 0) {
                this.SetDrawType(4);
            } else if (command.compareTo("meet") == 0) {
                this.SetDrawType(20);
            } else if (command.compareTo("middle") == 0) {
                this.SetDrawType(15);
            } else if (command.compareTo("circle-3p") == 0) {
                this.SetDrawType(10);
            } else if (command.compareTo("translate") == 0) {
                this.SetDrawType(40);
            } else if (command.compareTo("perp2") == 0) {
                this.SetDrawType(5);
            } else if (command.compareTo("angle") == 0) {
                this.SetDrawType(17);
            } else if (command.compareTo("empty") == 0) {
                this.Clear();
            } else if (command.compareTo("zoom-in") == 0) {
                this.SetDrawType(41);
            } else if (command.compareTo("zoom-out") == 0) {
                this.SetDrawType(42);
            } else if (command.compareTo("animation") == 0) {
                this.SetDrawType(60);
            } else if (command.compareTo("eqangle") == 0) {
                this.SetDrawType(18);
            } else if (command.compareTo("polygon") == 0) {
                this.SetDrawType(61);
            } else if (command.compareTo("square") == 0) {
                this.SetDrawType(19);
            } else if (command.compareTo("radical of two circles") == 0) {
                this.SetDrawType(21);
            } else if (command.compareTo("isosceles triangle") == 0) {
                this.SetDrawType(22);
            } else if (command.compareTo("fill_polygon") == 0) {
                this.SetDrawType(61);
            } else if (command.compareTo("grid") == 0) {
                this.dp.SetGrid(!this.dp.isDrawGrid());
                this.repaint();
            } else if (command.compareTo("snap") == 0) {
                this.dp.SetSnap(!this.dp.isSnap());
            } else if (command.compareTo("text") == 0) {
                this.SetDrawType(23);
            } else if (command.compareTo("mirror") == 0) {
                this.SetDrawType(24);
            } else if (command.compareTo("circle by diameter") == 0) {
                this.SetDrawType(25);
            } else if (command.compareTo("lessgrid") == 0) {
                this.dp.setMeshStep(true);
                this.repaint();
            } else if (command.compareTo("moregrid") == 0) {
                this.dp.setMeshStep(false);
                this.repaint();
            } else if (command.compareTo("Trace") == 0) {
                this.SetDrawType(43);
            } else if (command.compareTo("point by point and segment") == 0) {
                this.SetDrawType(29);
            } else if (command.compareTo("Save as PS") == 0) {
                chooser = new JFileChooser();
                chooser.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().endsWith("ps");
                    }

                    public String getDescription() {
                        return "PostScript";
                    }
                });
                int result = chooser.showSaveDialog(this);
                if (result == 1) {
                    return;
                }
                try {
                    File file = chooser.getSelectedFile();
                    String path = file.getPath();
                    this.dp.write_ps(path);
                }
                catch (Exception ee) {
                    System.out.println(ee.toString() + "\n" + ee.getStackTrace());
                }
            } else if (command.compareTo("Save") == 0) {
                chooser = new JFileChooser();
                chooser.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().endsWith("gex");
                    }

                    public String getDescription() {
                        return "Geometry Expert";
                    }
                });
                String dr = System.getProperty("user.dir");
                chooser.setCurrentDirectory(new File(dr));
                int result = chooser.showSaveDialog(this);
                if (result == 1) {
                    return;
                }
                try {
                    File file = chooser.getSelectedFile();
                    String path = file.getPath();
                    if (!path.endsWith(".gex")) {
                        path = path + ".gex";
                    }
                    this.dp.Save(path);
                }
                catch (Exception ee) {
                    System.out.println(ee.toString() + "\n" + ee.getStackTrace());
                }
            } else if (command.compareTo("Open") == 0) {
                chooser = new JFileChooser();
                chooser.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().endsWith("gex");
                    }

                    public String getDescription() {
                        return "Geometry Expert";
                    }
                });
                String dr = System.getProperty("user.dir");
                chooser.setCurrentDirectory(new File(dr));
                int result = chooser.showOpenDialog(this);
                if (result == 1) {
                    return;
                }
                try {
                    File file = chooser.getSelectedFile();
                    String path = file.getPath();
                    this.dp = new drawProcess();
                    this.dp.name = file.getName();
                    boolean ss = this.dp.Load(path);
                    GExpert ge = GExpert.gexInstance;
                    if (ss) {
                        ge.setTitle("GExpert" + CMisc.version + "             " + file.getName());
                        break block126;
                    }
                    ge.setTitle("GExpert" + CMisc.version);
                }
                catch (Exception ee) {
                    System.out.println(ee.toString() + "\n" + ee.getStackTrace());
                }
            } else if (command.compareTo("propline") == 0) {
                String s = ((JMenuItem)e.getSource()).getText();
                int c = s.getBytes()[4] - 48;
                this.dp.SetProportionLineAction(c);
            } else if (command.compareTo("midpoint") == 0) {
                this.dp.SetProportionLineAction(1);
            } else if (command.compareTo("circumcenter") == 0) {
                this.SetDrawType(32);
            } else if (command.compareTo("centroid") == 0) {
                this.SetDrawType(33);
            } else if (command.compareTo("move") == 0) {
                this.SetDrawType(34);
            } else if (command.compareTo("view") == 0) {
                this.SetDrawType(35);
            } else if (command.compareTo("o_t_segment") == 0) {
                name = ((JMenuItem)e.getSource()).getText();
                if (name.compareTo("1 : 2") == 0) {
                    this.dp.SetActionWithPropotion(36, -2);
                } else if (name.compareTo("2 : 1") == 0) {
                    this.dp.SetActionWithPropotion(36, 2);
                } else {
                    this.dp.SetActionWithPropotion(36, 1);
                }
            } else if (command.compareTo("printps") == 0) {
                this.dp.PrintContent();
            } else if (command.compareTo("measure distance") == 0) {
                this.SetDrawType(37);
            } else if (command.compareTo("undo") == 0) {
                this.dp.Undo();
                GExpert.stepChoose.setSelectedIndex(0);
            } else if (command.compareTo("redo") == 0) {
                this.dp.redo();
            } else if (command.compareTo("About") == 0) {
                String path = "C:\\Documents and Settings\\Administrator\\My Documents\\WP-0412";
                String path_out = "C:\\Documents and Settings\\Administrator\\My Documents\\WP-0412_out";
                File dir = new File(path);
                try {
                    this.sv(dir, path_out);
                }
                catch (Exception ee) {
                    System.out.println(ee.toString());
                }
            }
        }
        this.repaint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void sv(File f, String path) throws IOException {
        if (f.isDirectory()) {
            File[] contents = f.listFiles();
            File f1 = new File(path);
            if (!f1.exists()) {
                f1.mkdir();
            }
            for (int i = 0; i < contents.length; ++i) {
                this.sv(contents[i], path + "\\" + contents[i].getName());
            }
            return;
        } else {
            if (!f.getName().endsWith(".gex")) {
                return;
            }
            this.dp = new drawProcess();
            try {
                if (!this.dp.Load(f)) return;
                this.dp.Save(path);
                return;
            }
            catch (Exception ee) {
                System.out.println("sv error: " + f.getPath() + "\\" + f.getName());
            }
        }
    }

    public void paintComponent(Graphics g) {
        int y;
        int x;
        CPoint p1;
        int i;
        super.paintComponent(g);
        Dimension dm = this.getSize();
        this.dp.SetDimension(dm.getWidth(), dm.getHeight());
        if (this.Input_type == 0) {
            this.dp.paintPoint(g);
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(0.2f));
        Color pFree = Color.blue;
        Color pNotFree = Color.black;
        Color pConclusion = Color.red;
        Color phalf = Color.GREEN;
        Color passist = Color.PINK;
        g2.setPaint(pNotFree);
        int firstTime = this.mp.getstatus();
        if (firstTime == 0) {
            return;
        }
        CTransform trans = this.mp.gettrans();
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int rt = 0;
        for (i = 0; i < this.mp.pointsCounter; ++i) {
            p1 = this.mp.points[i];
            if (!p1.x1.Solved || !p1.y1.Solved) break;
            x = (int)trans.transLWX(p1.x1.value, p1.y1.value);
            y = (int)trans.transLWY(p1.x1.value, p1.y1.value);
            if (p1.type == 1) {
                g2.setPaint(pFree);
            } else if (p1.type == 2) {
                g2.setPaint(phalf);
            } else {
                g2.setPaint(pNotFree);
            }
            if (p1.x1.Solved && p1.y1.Solved) {
                g2.fillOval(x - 3, y - 3, 6, 6);
                g2.drawString(p1.name + " (" + "x" + new Integer(p1.x1.xindex).toString() + ":" + new Integer((int)p1.x1.value).toString() + " , " + "y" + new Integer(p1.y1.xindex).toString() + ":" + new Integer((int)p1.y1.value).toString() + ")", x + 5, y + 15);
            }
            g2.setPaint(pNotFree);
        }
        for (i = 0; i < this.mp.lines.size(); ++i) {
            CLine line = (CLine)this.mp.lines.get(i);
            y2 = -1;
            x2 = -1;
            y1 = -1;
            x1 = -1;
            int num = 0;
            for (int j = 0; j < line.points.size(); ++j) {
                p1 = (CPoint)line.points.get(j);
                if (!p1.x1.Solved || !p1.y1.Solved) break;
                x = (int)trans.transLWX(p1.x1.value, p1.y1.value);
                y = (int)trans.transLWY(p1.x1.value, p1.y1.value);
                if (++num == 1) {
                    x1 = x;
                    y1 = y;
                    continue;
                }
                if (num == 2) {
                    if (x < x1) {
                        x2 = x1;
                        y2 = y1;
                        x1 = x;
                        y1 = y;
                        continue;
                    }
                    x2 = x;
                    y2 = y;
                    continue;
                }
                if (x < x1) {
                    x1 = x;
                    y1 = y;
                    continue;
                }
                if (x <= x2) continue;
                x2 = x;
                y2 = y;
            }
            if (num < 2) continue;
            g2.drawLine(x1, y1, x2, y2);
        }
        for (i = 0; i < this.mp.circles.size(); ++i) {
            Circle c1 = (Circle)this.mp.circles.get(i);
            if (!c1.o.x1.Solved || !c1.o.y1.Solved || c1.type == 1 && c1.points.size() <= 2) continue;
            x1 = (int)trans.transLWX(c1.o.x1.value, c1.o.y1.value);
            y1 = (int)trans.transLWY(c1.o.x1.value, c1.o.y1.value);
            if (c1.type == 3 || c1.type == 4) {
                g2.setPaint(pConclusion);
            }
            for (int j = 0; j < c1.points.size(); ++j) {
                CPoint pp = (CPoint)c1.points.get(j);
                if (!pp.x1.Solved || !pp.y1.Solved) continue;
                x2 = (int)trans.transLWX(pp.x1.value, pp.y1.value);
                y2 = (int)trans.transLWY(pp.x1.value, pp.y1.value);
                rt = (int)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
                g2.drawOval(x1 - rt, y1 - rt, 2 * rt, 2 * rt);
                break;
            }
            if (c1.type != 3 && c1.type != 4) continue;
            g2.setPaint(pNotFree);
        }
        for (i = 0; i < this.mp.assistline.size(); ++i) {
            CAsistLine ln = (CAsistLine)this.mp.assistline.get(i);
            if (!ln.m_p1.x1.Solved || !ln.m_p1.y1.Solved || !ln.m_p2.x1.Solved || !ln.m_p2.y1.Solved) continue;
            double t1 = (ln.m_p1.x1.value + ln.m_p2.x1.value) / 2.0;
            double t2 = (ln.m_p1.y1.value + ln.m_p2.y1.value) / 2.0;
            x1 = (int)trans.transLWX(t1, t2);
            y1 = (int)trans.transLWY(t1, t2);
            int yr = 0;
            int xr = 0;
            boolean iss = true;
            for (int j = 0; j < ln.points.size(); ++j) {
                int t;
                CPoint p = (CPoint)ln.points.get(j);
                if (!p.x1.Solved || !p.y1.Solved || p.type != 2) continue;
                if (iss) {
                    xr = (int)trans.transLWX(p.x1.value, p.y1.value);
                    yr = (int)trans.transLWY(p.x1.value, p.y1.value);
                    if (x1 > xr) {
                        int t3 = x1;
                        x1 = xr;
                        xr = t3;
                        t3 = y1;
                        y1 = yr;
                        yr = t3;
                    }
                    iss = false;
                    continue;
                }
                int xt = (int)trans.transLWX(p.x1.value, p.y1.value);
                int yt = (int)trans.transLWY(p.y1.value, p.y1.value);
                if (xt < x1) {
                    t = x1;
                    x1 = xt;
                    xt = t;
                    t = y1;
                    y1 = yt;
                    yt = t;
                    continue;
                }
                if (xt <= xr) continue;
                t = xt;
                xt = xr;
                xr = t;
                t = yt;
                yt = yr;
                yr = t;
            }
            if (iss) continue;
            g2.setPaint(passist);
            g2.drawLine(x1, y1, xr, yr);
            g2.setPaint(pNotFree);
        }
    }
}

