/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import wprover.GeoCond;
import wprover.GeoPoly;
import wprover.TMono;
import wprover.Thm;

public class Input {
    private GeoPoly poly = GeoPoly.getPoly();
    public String theorem_name;
    private Thm[] thmptr = new Thm[50];
    private int number_thm;
    private int end_of_file = 0;
    public TMono[] geohyp = new TMono[50];
    public int geohypn;
    private String gfile;
    private String gfile_previous;
    private int pbalance = 0;
    private static Input in = new Input();

    public String[] getthmname() {
        String[] name = new String[this.number_thm];
        for (int i = 0; i < this.number_thm; ++i) {
            name[i] = new String(this.thmptr[i].thname);
            name[i] = name[i].trim();
        }
        return name;
    }

    Thm getThm(String name) {
        for (int i = 0; i < this.thmptr.length; ++i) {
            String s = new String(this.thmptr[i].thname);
            if ((s = s.trim()).compareTo(name) != 0) continue;
            return this.thmptr[i];
        }
        return null;
    }

    char[] uppercase(char[] s) {
        String ss = new String(s);
        return ss.toUpperCase().toCharArray();
    }

    void getfilename() throws IOException {
        InputStream in = System.in;
        byte[] buf = new byte[100];
        int len = in.read(buf);
        this.gfile = new String(buf, 0, len - 1).trim();
    }

    String getname() throws IOException {
        InputStream in = System.in;
        byte[] buf = new byte[100];
        int len = in.read(buf);
        return new String(buf, 0, len - 1).trim();
    }

    void test_eof(int c) {
        if (c < 0 && this.pbalance != 0) {
            System.err.println("input file error: unexpected end of file");
            System.exit(1);
        }
    }

    int skipblank(FileInputStream fp) throws IOException {
        int c = fp.read();
        this.test_eof(c);
        while (c == 32 || c == 10 || c == 9 || c == 13) {
            c = fp.read();
            this.test_eof(c);
        }
        return c;
    }

    int getword(FileInputStream fp, char[] word, int c1) throws IOException {
        int i = 0;
        if (c1 > 0) {
            word[0] = (char)c1;
            i = 1;
        }
        int c = fp.read();
        while (c != 32 && c != 10 && c != 41 && c != 9) {
            this.test_eof(c);
            word[i] = (char)c;
            ++i;
            c = fp.read();
        }
        if (c == 41) {
            --this.pbalance;
        }
        word[i] = '\u0000';
        return c;
    }

    int read_a_coord(FileInputStream fp, Thm thmptr) throws IOException {
        char[] pt = new char[6];
        int c = this.getkeychar(fp, 40, 0);
        if (c == 41) {
            return 0;
        }
        this.getword(fp, pt, -1);
        int i = ++thmptr.coordn;
        pt = this.uppercase(pt);
        String ptStr = new String(pt).trim();
        thmptr.pts[i].setPt(ptStr.toCharArray());
        Arrays.fill(pt, '\u0000');
        c = this.skipblank(fp);
        this.getword(fp, pt, c);
        ptStr = new String(pt).trim();
        thmptr.pts[i].setX(new Integer(ptStr));
        Arrays.fill(pt, '\u0000');
        c = this.skipblank(fp);
        this.getword(fp, pt, c);
        ptStr = new String(pt).trim();
        thmptr.pts[i].setY(new Integer(ptStr));
        return 1;
    }

    int read_a_point(FileInputStream fp, Thm thmptr, int hypon) throws IOException {
        char[] pt = new char[6];
        int c = this.getword(fp, pt, -1);
        pt = this.uppercase(pt);
        int i = ++thmptr.hp[hypon].ptn;
        thmptr.hp[hypon].pts[i] = new String(pt).toCharArray();
        if (c == 41) {
            return 0;
        }
        return 1;
    }

    int read_a_hypo(FileInputStream fp, Thm thmptr) throws IOException {
        char[] hypo = new char[20];
        int c = this.getkeychar(fp, 40, 0);
        if (c == 41) {
            return 0;
        }
        this.getword(fp, hypo, -1);
        int i = ++thmptr.hypon;
        thmptr.hp[i].cond = new String(hypo).toCharArray();
        while (this.read_a_point(fp, thmptr, i) > 0) {
        }
        return 1;
    }

    int getkeychar(FileInputStream fp, int c1, int fatal) throws IOException {
        int c = this.skipblank(fp);
        if (c != c1 && fatal == 1) {
            System.out.print("unexpected char: " + c + " = " + c + "\n");
            System.exit(1);
        }
        switch (c) {
            case 39: {
                break;
            }
            case 40: {
                ++this.pbalance;
                break;
            }
            case 41: {
                --this.pbalance;
                break;
            }
            default: {
                this.showc(c);
                this.showc(c1);
                System.out.print("Input file error\n");
                System.exit(1);
            }
        }
        return c;
    }

    Thm read_a_thm(FileInputStream fp, Thm thmptr) throws IOException {
        char[] word = new char[40];
        int c = 0;
        this.pbalance = 0;
        thmptr.coordn = -1;
        thmptr.hypon = -1;
        for (int i = 0; i < 40; ++i) {
            thmptr.hp[i].ptn = -1;
        }
        c = fp.read();
        while (c == 32 || c == 10 || c == 9) {
            c = (char)fp.read();
        }
        if (c == 40) {
            ++this.pbalance;
        } else {
            if (c < 0) {
                this.end_of_file = 1;
                return null;
            }
            if (c >= 65535) {
                this.end_of_file = 1;
                System.out.println("END OF FILE");
                return null;
            }
        }
        this.getword(fp, word, -1);
        if (!GeoCond.eqword(word, "defvar".toCharArray()) && !GeoCond.eqword(word, "setq".toCharArray())) {
            System.out.println("not key word");
            System.exit(1);
        }
        c = (char)this.skipblank(fp);
        this.getword(fp, word, c);
        thmptr.thname = new String(word).toCharArray();
        this.getkeychar(fp, 39, 1);
        this.getkeychar(fp, 40, 1);
        this.getkeychar(fp, 40, 1);
        while (this.read_a_coord(fp, thmptr) > 0) {
        }
        while (this.read_a_hypo(fp, thmptr) > 0) {
        }
        return thmptr;
    }

    void showthm_coord(Thm ptr) {
        for (int i = 0; i <= ptr.coordn; ++i) {
            System.out.println("(" + ptr.pts[i].getPt() + " " + ptr.pts[i].getX() + " " + ptr.pts[i].getY() + ")");
        }
    }

    void showthm(Thm ptr) {
        this.shows(ptr.thname);
        this.showthm_coord(ptr);
        for (int i = 0; i <= ptr.hypon; ++i) {
            System.out.print(ptr.hp[i].cond);
            for (int j = 0; j <= ptr.hp[i].ptn; ++j) {
                System.out.print(ptr.hp[i].pts[j]);
            }
            System.out.print("\n");
        }
    }

    void print_geocond() {
        for (int i = 0; i < GeoCond.geocondnum; ++i) {
            System.out.println("i = " + i + ": " + GeoCond.geocond[i]);
        }
    }

    void step1() {
        int i;
        System.out.print("Step 1: Convert the hypotheses into a set of polynomial equations\n");
        System.out.print("  The set of hypothesis polynomials is:\n");
        for (i = 0; i < this.geohypn; ++i) {
            System.out.print("h = " + (i + 1));
            this.poly.printpoly(this.geohyp[i]);
        }
        System.out.print(" The conclusion polynomial equation is\n");
        System.out.print("c = ");
        this.poly.printpoly(this.geohyp[i]);
    }

    void showa(char[] st, int n) {
        for (int i = 0; i < n; ++i) {
            this.showc(st[i]);
        }
    }

    boolean read_input(String name) throws IOException {
        int i = -1;
        this.gfile = new String(name);
        if (this.gfile != null && (this.gfile_previous == null || this.gfile.compareTo(this.gfile_previous) != 0)) {
            File gf = new File(this.gfile);
            if (!gf.exists()) {
                return false;
            }
            FileInputStream fp = new FileInputStream(gf);
            if (fp == null) {
                return false;
            }
            this.gfile_previous = new String(this.gfile);
            while (true) {
                this.read_a_thm(fp, this.thmptr[++i]);
                if (this.end_of_file == 1) break;
                this.getkeychar(fp, 41, 1);
            }
            System.out.print(i + " theorems have beeen successfully read --\n\n");
            this.number_thm = i;
            fp.close();
        }
        return true;
    }

    private void shows(char[] x) {
        System.out.println("x = " + new String(x));
    }

    private void showc(int x) {
        System.out.println("x = " + x);
    }

    private Input() {
        int i;
        for (i = 0; i < this.thmptr.length; ++i) {
            this.thmptr[i] = new Thm();
        }
        for (i = 0; i < this.geohyp.length; ++i) {
            this.geohyp[i] = new TMono();
        }
    }

    public static Input getInstance() {
        return in;
    }
}

