/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import wprover.CharSet;
import wprover.GeoPoly;
import wprover.Input;
import wprover.TMono;
import wprover.TPoly;

public class Main {
    private static GeoPoly poly = GeoPoly.getPoly();
    private static Input in = Input.getInstance();
    private static CharSet charset = CharSet.getinstance();

    static void print_hyps(TMono[] H, int jj, String h, TPoly ps) {
        if (h.compareTo("h") == 0) {
            System.out.println("The hypothesis polynomial set is:");
            for (int i = 0; i < jj; ++i) {
                System.out.print(h + "_" + i + " = ");
                poly.pr(H[i]);
            }
            System.out.print("\nThe conclusion polynomial is:\nc = ");
            poly.pr(H[jj]);
        } else {
            int i = --jj;
            System.out.print("\nThe hypothesis polynomial set in triangular form is:\n");
            for (TPoly tp = ps; tp != null; tp = tp.getNext()) {
                System.out.print(h + "_" + i-- + " = ");
                poly.pr(tp.getPoly());
            }
        }
    }

    static void print(TMono tp, TPoly ps3, int i) {
    }

    static void prove() {
        TPoly ps1 = null;
        TPoly ps2 = null;
        TPoly ps3 = null;
        int i = Main.in.geohypn;
        int ii = Main.in.geohypn;
        int n = ii - 1;
        boolean first = true;
        if (first) {
            first = !first;
            for (int jj = 0; jj <= ii; ++jj) {
                ps1 = charset.pushpoly(Main.in.geohyp[jj], ps1);
            }
        }
        System.out.println("Step 1 convert the geometric conditions into polynomial form:");
        Main.print_hyps(Main.in.geohyp, ii, "h", ps2);
        long start = System.currentTimeMillis();
        ps2 = charset.charset(ps1.getNext());
        System.out.println("\nStep 2 Transform the hypothesis polynomial set into trianguar form:");
        Main.print_hyps(Main.in.geohyp, ii, "f", ps2);
        TMono tp = ps1.getPoly();
        System.out.println("\nStep 3 Successive Pseudo Division:");
        System.out.println("Let R_" + i + " = c (the conclusion polynomial)");
        for (ps3 = ps2; ps3 != null; ps3 = ps3.getNext()) {
            tp = poly.prem(tp, ps3.getPoly());
            Main.print(tp, ps3, i);
            --i;
        }
        int result = poly.plength(tp);
        long end = System.currentTimeMillis();
        System.out.println("\nStep 4 check the final remainder:");
        if (result == 0) {
            System.out.println("Since the final remainder R0 is zero, and we have\n   the following remainder formula for successive pseudo division:\n\n     I0^s0 I1^s1 ... I" + n + "^s" + n + " c = Q0 f0 + Q1 f1 + ... + Q" + n + " f" + n + " + R0\n" + "\nthe " + Main.in.theorem_name.trim() + " theorem is proved under non-degenerate conditions " + "\n\n     I0 != 0, ..., I" + n + " != 0\n\n" + "where I_i is the leading coefficient of f_i. QED.\n");
            System.out.println("Complete in : " + (double)(end - start) / 1000.0 + " seconds");
        } else {
            System.out.println("since the final remainder R_" + i + " is not zero,\n" + "the statement is not confirmed");
            System.out.println((double)(end - start) / 1000.0 + " seconds");
        }
    }

    public static void main(String[] args) {
        long start = 0L;
        try {
            while (true) {
                System.out.print("Please input file name: ");
                in.read_input(new String(in.getname()));
                start = System.currentTimeMillis();
                Main.prove();
                System.out.println("\n       ********** end of proof of " + Main.in.theorem_name.trim() + " theorem **********\n");
            }
        }
        catch (Exception ex) {
            long end = System.currentTimeMillis();
            System.out.println("Used time is : " + (double)(end - start) / 1000.0);
            ex.printStackTrace();
            return;
        }
    }
}

