/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import wprover.TMono;
import wprover.TPoly;
import wprover.param;

public class PolyBasic {
    private static int MAXSTR = 70;
    private static PolyBasic basic = new PolyBasic();

    public static PolyBasic getInstance() {
        return basic;
    }

    private TMono pp_plus(TMono p1, TMono p2, boolean es) {
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        TMono poly = null;
        if (p1.x < p2.x || p1.x == p2.x && p1.deg < p2.deg) {
            TMono t = p1;
            p1 = p2;
            p2 = t;
        }
        poly = p1;
        if (p1.x > p2.x) {
            while (p1.next != null) {
                p1 = p1.next;
            }
            if (p1.deg != 0) {
                p1.next = new TMono();
                p1.next.x = p1.x;
                p1 = p1.next;
                p1.coef = p2;
            } else {
                p1.coef = this.pp_plus(p1.coef, p2, true);
            }
        } else if (p1.deg > p2.deg) {
            p1.next = this.pp_plus(p1.next, p2, false);
        } else if (this.Int(p1)) {
            long v = p1.val + p2.val;
            if (v == 0L) {
                return null;
            }
            p1.val = v;
        } else {
            p1.coef = this.pp_plus(p1.coef, p2.coef, true);
            p1.next = this.pp_plus(p1.next, p2.next, false);
        }
        if (poly != null && poly.coef == null && poly.deg != 0) {
            poly = poly.next;
        }
        if (es && poly != null && poly.deg == 0 && poly.x != 0) {
            poly = poly.coef;
        }
        return poly;
    }

    private TMono pp_minus(TMono p1, TMono p2) {
        TMono m = this.pp_plus(p1, this.cp_times(-1L, p2), true);
        return m;
    }

    private TMono cp_times(long c, TMono p1) {
        if (p1 == null || c == 0L) {
            return null;
        }
        if (this.Int(p1)) {
            p1.val *= c;
            return p1;
        }
        p1.coef = this.cp_times(c, p1.coef);
        p1.next = this.cp_times(c, p1.next);
        return p1;
    }

    private TMono pp_times(TMono p1, TMono p2) {
        if (p1 == null || p2 == null) {
            return null;
        }
        TMono tp = null;
        if (p1.x > p2.x) {
            tp = p1;
            p1 = p2;
            p2 = tp;
        }
        TMono poly = null;
        while (p1 != null) {
            TMono tt;
            tp = p1;
            p1 = p1.next;
            tp.next = null;
            if (p1 != null) {
                tt = this.mp_times(tp, this.p_copy(p2));
            } else {
                if (tp.deg == 0 && tp.x != 0) {
                    tp = tp.coef;
                }
                tt = this.mp_times(tp, p2);
            }
            while (tt != null && tt.deg == 0 && tt.x != 0) {
                tt = tt.coef;
            }
            while (tt != null && tt.x != 0 && tt.coef == null) {
                tt = tt.next;
            }
            poly = this.pp_plus(poly, tt, true);
        }
        return poly;
    }

    private TMono mp_times(TMono p1, TMono p2) {
        TMono poly = p2;
        if (p1 == null || p2 == null) {
            return null;
        }
        if (this.Int(p1)) {
            return this.cp_times(p1.val, p2);
        }
        if (p1.x == p2.x) {
            while (p2 != null) {
                p2.deg += p1.deg;
                p2.coef = p2.next != null ? this.pp_times(this.p_copy(p1.coef), p2.coef) : this.pp_times(p1.coef, p2.coef);
                p2 = p2.next;
            }
        } else if (p1.x < p2.x) {
            while (p2 != null) {
                p2.coef = p2.next != null ? this.pp_times(this.p_copy(p1), p2.coef) : this.pp_times(p1, p2.coef);
                p2 = p2.next;
            }
        } else {
            System.out.println("Error,must p1.x < p2.x");
        }
        return poly;
    }

    public int deg(TMono p, int x) {
        if (p.x == x) {
            return p.deg;
        }
        if (p.x > x) {
            int d2;
            int d1 = this.deg(p.coef, x);
            return d1 > (d2 = this.deg(p.next, x)) ? d1 : d2;
        }
        return 0;
    }

    TMono prem(TMono p1, TMono p2) {
        if (p1 == null) {
            return null;
        }
        TMono result = null;
        if (p1.x < p2.x) {
            result = p1;
        } else {
            if (p1.x > p2.x) {
                TMono m1 = this.prem(p1.coef, p2);
                TMono m2 = this.prem(p1.next, p2);
                if (m1 == null) {
                    return m2;
                }
                p1.coef = m1;
                p1.next = m2;
                return p1;
            }
            if (p1.x == p2.x) {
                if (p1.deg < p2.deg) {
                    result = p1;
                } else if (p1.deg == p2.deg) {
                    p2 = this.p_copy(p2);
                    result = this.pp_minus(this.pp_times(p1.next, p2.coef), this.pp_times(p1.coef, p2.next));
                } else if (p1.deg > p2.deg) {
                    TMono poly = p1;
                    int x = p2.x;
                    int d1 = this.deg(poly, x);
                    int d2 = this.deg(p2);
                    while (d1 >= d2) {
                        TMono tp;
                        int dd = d1 - d2;
                        if (dd > 0) {
                            tp = this.pth(x, 1, dd);
                            tp = this.pp_times(tp, this.p_copy(p2));
                        } else {
                            tp = this.p_copy(p2);
                        }
                        poly = this.pp_minus(this.pp_times(poly.next, tp.coef), this.pp_times(poly.coef, tp.next));
                        if (poly == null) break;
                        d1 = this.deg(poly, x);
                    }
                    result = poly;
                }
            }
        }
        while (result != null && result.deg == 0 && result.x != 0) {
            result = result.coef;
        }
        this.coefgcd(result);
        result = this.factor_remove(result, p2.coef);
        return result;
    }

    public TMono factor_remove(TMono p1, TMono p2) {
        if (this.canfactor(p1, p2)) {
            TMono mr = new TMono();
            boolean b = this.factor(this.p_copy(p1), p2, mr);
            if (b && mr.next != null) {
                System.out.println("p1 can be factored.");
                return this.factor_remove(mr.next, p2);
            }
            return p1;
        }
        return p1;
    }

    private boolean canfactor(TMono p1, TMono p2) {
        if (p1 == null) {
            return true;
        }
        if (this.pp_compare(p1, p2) < 0) {
            return false;
        }
        if (p1.x != 0 && p1.deg == 0) {
            p1 = p1.next;
        }
        if (p2.x != 0 && p2.deg == 0) {
            p2 = p2.next;
        }
        TMono mr = new TMono();
        TMono m1 = this.p_copy(p1.coef);
        if (p1.x > p2.x) {
            return this.factor(m1, p2, mr);
        }
        return this.factor(m1, p2.coef, mr);
    }

    private boolean factor(TMono p1, TMono p2, TMono mr) {
        if (p1 == null) {
            mr.next = null;
            return false;
        }
        if (p2 == null) {
            return false;
        }
        if (this.pp_compare(p1, p2) < 0) {
            return false;
        }
        if (p1.x > p2.x) {
            boolean r = this.factor(p1.coef, p2, mr);
            if (!r) {
                return false;
            }
            TMono m1 = mr.next;
            r = this.factor(p1.next, p2, mr);
            if (!r) {
                return false;
            }
            TMono m2 = mr.next;
            p1.coef = m1;
            p1.next = m2;
            mr.next = p1;
            return true;
        }
        if (this.Int(p1)) {
            long v = p1.val % p2.val;
            if (v == 0L) {
                p1.val /= p2.val;
                mr.next = p1;
                return true;
            }
            return false;
        }
        int d = p1.deg - p2.deg;
        boolean r = this.factor(p1.coef, p2.coef, mr);
        if (!r) {
            return false;
        }
        TMono c = mr.next;
        TMono m = new TMono(p1.x, c, d);
        r = this.factor(this.pp_minus(p1.next, this.pp_times(this.p_copy(m), this.p_copy(p2.next))), p2, mr);
        if (!r) {
            return false;
        }
        m.next = mr.next;
        mr.next = m;
        return true;
    }

    TMono p_copy(TMono p) {
        if (p == null) {
            return null;
        }
        TMono p1 = new TMono();
        p1.x = p.x;
        p1.deg = p.deg;
        p1.val = p.val;
        p1.coef = this.p_copy(p.coef);
        p1.next = this.p_copy(p.next);
        return p1;
    }

    private int pp_compare(TMono p1, TMono p2) {
        if (p1.x < p2.x || p1.x == p2.x && p1.deg < p2.deg) {
            return -1;
        }
        if (p1.x > p2.x || p1.x == p2.x && p1.deg > p2.deg) {
            return 1;
        }
        return 0;
    }

    private boolean Int(TMono p) {
        return p.x == 0 && p.deg == 0;
    }

    void print(TMono p) {
        System.out.print(this.plength(p) + " :");
        this.p_print(p, false, true);
        System.out.print("\n");
    }

    private void p_print(TMono p, boolean ce, boolean first) {
        if (p == null) {
            return;
        }
        if (p.next == null) {
            ce = false;
        }
        if (ce) {
            if (first) {
                System.out.print("(");
            } else {
                System.out.print(" + (");
            }
            this.m_print(p, true);
            p = p.next;
            while (p != null) {
                this.m_print(p, false);
                p = p.next;
            }
            System.out.print(")");
        } else if (!first) {
            while (p != null) {
                this.m_print(p, false);
                p = p.next;
            }
        } else {
            this.m_print(p, true);
            p = p.next;
            while (p != null) {
                this.m_print(p, false);
                p = p.next;
            }
        }
    }

    private void m_print(TMono p, boolean first) {
        if (p.x == 0) {
            if (!first) {
                if (p.val > 0L) {
                    System.out.print(" + ");
                } else {
                    System.out.print(" - ");
                }
                long t = Math.abs(p.val);
                if (t != 1L) {
                    System.out.print(t);
                }
            } else if (p.val != 1L) {
                System.out.print(p.val);
            }
        } else if (p.deg == 0) {
            this.p_print(p.coef, false, first);
        } else {
            this.p_print(p.coef, true, first);
            if (p.deg != 1) {
                System.out.print("x_" + p.x + "^" + p.deg);
            } else {
                System.out.print("x_" + p.x);
            }
        }
    }

    TMono pth(int x, int c, int d) {
        return new TMono(x, c, d);
    }

    int deg(TMono p) {
        return p.deg;
    }

    int lv(TMono p) {
        if (p == null) {
            return 0;
        }
        return p.x;
    }

    TMono pzero() {
        return null;
    }

    int plength(TMono m) {
        if (m == null) {
            return 0;
        }
        if (this.Int(m)) {
            return 1;
        }
        return this.plength(m.coef) + this.plength(m.next);
    }

    boolean pzerop(TMono m) {
        if (m == null) {
            return true;
        }
        if (this.Int(m)) {
            return m.val == 0L;
        }
        return this.pzerop(m.coef) && this.pzerop(m.next);
    }

    TPoly addpoly(TMono t, TPoly p) {
        TPoly poly = new TPoly();
        poly.setNext(p);
        poly.setPoly(t);
        return poly;
    }

    TPoly addPolytoList(TPoly pl, TPoly pp) {
        if (pl == null) {
            return pp;
        }
        while (pl != null) {
            pp = this.ppush(pl.getPoly(), pp);
            pl = pl.getNext();
        }
        return pp;
    }

    TPoly ppush(TMono t, TPoly pp) {
        int lee;
        TPoly p;
        int vra = this.lv(t);
        TPoly poly = new TPoly();
        poly.setNext(null);
        poly.setPoly(t);
        if (pp == null) {
            return poly;
        }
        TPoly former = null;
        if (t == null) {
            return pp;
        }
        for (p = pp; p != null && (lee = this.lv(p.getPoly())) > vra; p = p.getNext()) {
            former = p;
        }
        if (p == null || this.lv(p.getPoly()) < vra) {
            poly.setNext(p);
            if (former == null) {
                return poly;
            }
            former.setNext(poly);
            return pp;
        }
        while (p != null) {
            if (this.pp_compare(p.getPoly(), poly.getPoly()) < 0) {
                if (former == null) {
                    poly.setNext(p);
                    return poly;
                }
                former.setNext(poly);
                poly.setNext(p);
                return pp;
            }
            former = p;
            p = p.getNext();
        }
        if (former == null) {
            poly.setNext(p);
            return poly;
        }
        former.setNext(poly);
        return pp;
    }

    double calpoly(TMono m, param[] p) {
        if (m == null) {
            return 0.0;
        }
        if (this.Int(m)) {
            return m.val;
        }
        double v = this.calpoly(m.coef, p);
        double v1 = this.calpoly(m.next, p);
        return Math.pow(p[m.x - 1].value, m.deg) * v + v1;
    }

    double[] calculv(TMono mm, param[] p) {
        double[] result = null;
        int x = this.lv(mm);
        int d = this.deg(mm, x);
        if (d == 1) {
            double val = this.calpoly(mm.coef, p);
            if (Math.abs(val) < 0.001) {
                return null;
            }
            result = new double[1];
            double v1 = this.calpoly(mm.next, p);
            result[0] = val = -1.0 * v1 / val;
            return result;
        }
        if (d == 2) {
            TMono b1;
            TMono a1 = mm.coef;
            mm = mm.next;
            if (this.deg(mm) == 1) {
                b1 = mm.coef;
                mm = mm.next;
            } else {
                b1 = null;
            }
            TMono b2 = mm != null && this.deg(mm) == 0 ? mm.coef : null;
            double aa = this.calpoly(a1, p);
            double bb1 = this.calpoly(b1, p);
            double bb2 = this.calpoly(b2, p);
            double dl = bb1 * bb1 - 4.0 * aa * bb2;
            if (Math.abs(dl) < 0.001) {
                result = new double[]{-1.0 * bb1 / (2.0 * aa)};
                return result;
            }
            if (dl < 0.0) {
                return null;
            }
            dl = Math.sqrt(dl);
            result = new double[2];
            double x1 = (-1.0 * bb1 + dl) / (2.0 * aa);
            double x2 = (-1.0 * bb1 - dl) / (2.0 * aa);
            result[0] = x1;
            result[1] = x2;
            return result;
        }
        return null;
    }

    double[] calculv_2v(TMono mm, param[] p) {
        if (mm.next != null) {
            return this.calculv(mm.next.coef, p);
        }
        return null;
    }

    double[] calculate_online(TMono mm, param[] p) {
        int x = mm.x;
        double r1 = this.calpoly(mm.coef, p);
        TMono m1 = mm.next.coef;
        double r = this.calpoly(m1.coef, p);
        m1 = m1.next.coef;
        double r2 = this.calpoly(m1, p);
        if (Math.abs(r) < 0.001) {
            return null;
        }
        double[] result = new double[]{-1.0 * (r1 * p[x - 1].value + r2) / r};
        return result;
    }

    double[] calculv2poly(TMono mm1, TMono mm2, param[] p) {
        TMono m1;
        int d;
        int x = this.lv(mm1);
        if (this.deg(mm1, x) < this.deg(mm2, x)) {
            TMono m = mm1;
            mm1 = mm2;
            mm2 = m;
        }
        if ((d = this.deg(m1 = mm1, x)) == 2) {
            TMono b1;
            TMono a1 = m1.coef;
            m1 = m1.next;
            if (this.deg(m1) == 1) {
                b1 = m1;
                m1 = m1.next;
            } else {
                b1 = null;
            }
            TMono c1 = m1 != null ? m1 : null;
            double ra1 = this.calpoly(a1, p);
            double rb1 = this.calpoly(b1, p);
            double rc1 = this.calpoly(c1, p);
            double dl = rb1 * rb1 - 4.0 * ra1 * rc1;
            if (Math.abs(dl) < 0.001) {
                double[] result = new double[]{-1.0 * rb1 / (2.0 * ra1)};
                return result;
            }
            if (dl < 0.0) {
                return null;
            }
            dl = Math.sqrt(dl);
            if (Math.abs(ra1) < 0.001) {
                return null;
            }
            double[] result = new double[]{(-1.0 * rb1 + dl) / (2.0 * ra1), (-1.0 * rb1 - dl) / (2.0 * ra1)};
            return result;
        }
        double[] result = this.calculv(mm1, p);
        if (result == null) {
            result = this.calculv(mm2, p);
        }
        if (result == null) {
            System.out.println("parell two line");
            return null;
        }
        return result;
    }

    TMono pRtimes(TMono p1, TMono p2) {
        return this.pp_times(p1, p2);
    }

    TMono pQtimer(TMono t1, TMono t2, TMono t3, TMono t4) {
        return this.pp_times(this.p_copy(t1), this.pp_times(this.p_copy(t2), this.pp_times(this.p_copy(t3), this.p_copy(t4))));
    }

    TMono padd(TMono p1, TMono p2) {
        TMono m = this.pp_plus(p1, p2, true);
        return m;
    }

    TMono pdif(TMono p1, TMono p2) {
        TMono m = this.pp_minus(p1, p2);
        return m;
    }

    TMono redundancy(TMono m) {
        return m;
    }

    boolean isZero(TMono m) {
        if (m == null) {
            return true;
        }
        if (this.Int(m)) {
            return m.val == 0L;
        }
        if (m.x != 0 && m.coef == null) {
            return this.isZero(m.next);
        }
        return false;
    }

    TMono pcopy(TMono p) {
        return this.p_copy(p);
    }

    TMono ptimes(TMono p1, TMono p2) {
        return this.pp_times(p1, p2);
    }

    TMono pctimes(TMono p, int c) {
        return this.cp_times(c, p);
    }

    void pr(TMono m) {
        this.print(m);
    }

    void printpoly(TMono m) {
        this.print(m);
    }

    TMono getMinV(int x, TPoly p) {
        TMono poly = null;
        int exp = 0;
        while (p != null) {
            TMono m = p.getPoly();
            if (m.x != x) {
                p = p.getNext();
                continue;
            }
            int e = m.deg;
            if (e > 0 && (exp == 0 || e < exp)) {
                exp = e;
                poly = p.getPoly();
            }
            p = p.getNext();
        }
        return poly;
    }

    TPoly OptimizePoly(TPoly poly) {
        TPoly t = poly;
        while (poly != null) {
            TMono m = poly.getPoly();
            m = this.opt(m);
            poly.setPoly(m);
            poly = poly.getNext();
        }
        return t;
    }

    TMono opt(TMono m) {
        if (m == null) {
            return null;
        }
        if (this.Int(m)) {
            return m;
        }
        if (m.x <= 3 && m.x > 0) {
            return null;
        }
        m.coef = this.opt(m.coef);
        m.next = this.opt(m.next);
        if (m.coef == null && m.deg != 0) {
            m = m.next;
        }
        if (this.isZero(m)) {
            return null;
        }
        return m;
    }

    String pirntSPoly(TMono m) {
        return this.String_p_print(m, false, true);
    }

    private String String_p_print(TMono p, boolean ce, boolean first) {
        if (p == null) {
            return new String();
        }
        if (p.next == null) {
            ce = false;
        }
        String s = new String();
        if (ce) {
            s = first ? s + "(" : s + " + (";
            s = s + this.String_m_print(p, true);
            p = p.next;
            while (p != null) {
                if (s.length() > MAXSTR) {
                    return s;
                }
                s = s + this.String_m_print(p, false);
                p = p.next;
            }
            s = s + ")";
        } else if (!first) {
            while (p != null) {
                if (s.length() > MAXSTR) {
                    return s;
                }
                s = s + this.String_m_print(p, false);
                p = p.next;
            }
        } else {
            s = s + this.String_m_print(p, true);
            p = p.next;
            while (p != null) {
                if (s.length() > MAXSTR) {
                    return s;
                }
                s = s + this.String_m_print(p, false);
                p = p.next;
            }
        }
        return s;
    }

    private String String_m_print(TMono p, boolean first) {
        String s = new String();
        if (p.x == 0) {
            if (!first) {
                s = p.val > 0L ? s + " + " : s + " - ";
                long t = Math.abs(p.val);
                if (t != 1L) {
                    s = s + t;
                }
            } else if (p.val != 1L) {
                s = s + p.val;
            }
        } else if (p.deg == 0) {
            s = s + this.String_p_print(p.coef, false, first);
        } else {
            s = s + this.String_p_print(p.coef, true, first);
            s = p.deg != 1 ? s + "x_" + p.x + "^" + p.deg : s + "x_" + p.x;
        }
        return s;
    }

    private long coefgcd(TMono p) {
        long c = this.coefgcd(p, 0L);
        if (c > 1L) {
            this.coef_div(p, c);
        }
        return c;
    }

    private boolean coef_div(TMono m, long c) {
        if (m == null) {
            return true;
        }
        if (this.Int(m)) {
            if (m.val % c != 0L) {
                return false;
            }
            m.val /= c;
            return true;
        }
        if (this.coef_div(m.coef, c)) {
            return this.coef_div(m.next, c);
        }
        return false;
    }

    private long gcd(long a, long b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0L) {
            long t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    private long coefgcd(TMono p, long c) {
        if (p == null) {
            return c;
        }
        if (this.Int(p)) {
            if (c == 0L) {
                return Math.abs(p.val);
            }
            return this.gcd(c, p.val);
        }
        long cc = this.coefgcd(p.coef, c);
        if (c == 1L) {
            return 1L;
        }
        return this.coefgcd(p.next, cc);
    }
}

