/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import wprover.CCoBox;
import wprover.CText;
import wprover.drawData;

public class TextFrame
extends JFrame
implements ItemListener,
ActionListener,
FocusListener {
    JEditorPane textframe = null;
    CText text = null;
    JLabel fontLabel;
    JLabel sizeLabel;
    JLabel styleLabel;
    JLabel colorLabel;
    FontPanel fontC;
    JComboBox fonts;
    JComboBox sizes;
    JComboBox styles;
    JComboBox color;
    int index = 0;
    String fontchoice = "fontchoice";
    int stChoice = 0;
    String siChoice = "10";
    Vector fontfamily;
    Font defaultFont = new Font("Dialog", 0, 14);

    public void init() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        JPanel fontPanel = new JPanel();
        JPanel sizePanel = new JPanel();
        JPanel stylePanel = new JPanel();
        JPanel colorPanel = new JPanel();
        JPanel sizeAndStylePanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        fontPanel.setLayout(new GridLayout(2, 1));
        sizePanel.setLayout(new GridLayout(2, 1));
        stylePanel.setLayout(new GridLayout(2, 1));
        colorPanel.setLayout(new GridLayout(2, 1));
        sizeAndStylePanel.setLayout(new BorderLayout());
        topPanel.add("West", fontPanel);
        sizeAndStylePanel.add("West", sizePanel);
        sizeAndStylePanel.add("Center", stylePanel);
        sizeAndStylePanel.add("East", colorPanel);
        topPanel.add("Center", sizeAndStylePanel);
        this.getContentPane().add("North", topPanel);
        this.fontLabel = new JLabel();
        this.fontLabel.setText("Fonts");
        Font newFont = new Font("Arial", 0, 10);
        this.fontLabel.setFont(newFont);
        this.fontLabel.setHorizontalAlignment(0);
        fontPanel.add(this.fontLabel);
        this.sizeLabel = new JLabel();
        this.sizeLabel.setText("Sizes");
        this.sizeLabel.setFont(newFont);
        this.sizeLabel.setHorizontalAlignment(0);
        sizePanel.add(this.sizeLabel);
        this.styleLabel = new JLabel();
        this.styleLabel.setText("Styles");
        this.styleLabel.setFont(newFont);
        this.styleLabel.setHorizontalAlignment(0);
        stylePanel.add(this.styleLabel);
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        this.fontfamily = new Vector();
        for (int i = 1; i < envfonts.length; ++i) {
            this.fontfamily.addElement(envfonts[i]);
        }
        this.fonts = new JComboBox(this.fontfamily);
        this.fonts.setMaximumRowCount(9);
        this.fonts.addItemListener(this);
        this.fontchoice = envfonts[0];
        fontPanel.add(this.fonts);
        this.sizes = new JComboBox<Object>(new Object[]{new Integer(10), new Integer(12), new Integer(14), new Integer(16), new Integer(18)});
        this.sizes.setMaximumRowCount(9);
        this.sizes.addItemListener(this);
        sizePanel.add(this.sizes);
        this.styles = new JComboBox<Object>(new Object[]{"PLAIN", "BOLD", "ITALIC"});
        this.styles.setMaximumRowCount(9);
        this.styles.addItemListener(this);
        this.sizes.setMaximumRowCount(9);
        stylePanel.add(this.styles);
        this.fontC = new FontPanel();
        this.fontC.setBackground(Color.white);
        this.getContentPane().add("Center", this.fontC);
        this.color = CCoBox.CreateAInstance();
        this.colorLabel = new JLabel();
        this.colorLabel.setText("Color");
        this.colorLabel.setFont(newFont);
        this.colorLabel.setHorizontalAlignment(0);
        colorPanel.add(this.colorLabel);
        colorPanel.add(this.color);
        this.fonts.addActionListener(this);
        this.sizes.addActionListener(this);
        this.styles.addActionListener(this);
        this.color.addActionListener(this);
    }

    public void setCurrentFont(Font f) {
        int i;
        int size = f.getSize();
        int type = f.getStyle();
        String fname = f.getName();
        for (i = 0; i < this.fontfamily.size(); ++i) {
            String s = (String)this.fontfamily.get(i);
            if (s.compareTo(fname) != 0) continue;
            this.fonts.setSelectedIndex(i);
            break;
        }
        this.styles.setSelectedIndex(type);
        for (i = 0; i < this.sizes.getItemCount(); ++i) {
            int s = (Integer)this.sizes.getItemAt(i);
            if (s != size) continue;
            this.sizes.setSelectedIndex(i);
            break;
        }
    }

    public TextFrame() {
        this.setSize(400, 300);
        this.init();
        this.textframe = new JEditorPane();
        this.getContentPane().add(this.textframe);
        this.text = null;
        this.setCurrentFont(this.defaultFont);
    }

    void setText(CText tx) {
        this.text = tx;
        this.textframe.setText(tx.str);
        this.textframe.setFont(tx.font);
        Font f = tx.font;
        this.color.setSelectedIndex(tx.color);
        this.setCurrentFont(f);
    }

    CText getText() {
        String s = (String)this.fonts.getSelectedItem();
        int size = (Integer)this.sizes.getSelectedItem();
        int type = this.styles.getSelectedIndex();
        Font f = new Font(s, type, size);
        if (this.text != null) {
            this.text.str = this.textframe.getText();
            this.text.font = f;
            return this.text;
        }
        return null;
    }

    String getString() {
        return this.textframe.getText();
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String s = (String)this.fonts.getSelectedItem();
        int size = (Integer)this.sizes.getSelectedItem();
        int type = this.styles.getSelectedIndex();
        Font f = new Font(s, type, size);
        this.textframe.setFont(f);
        int id = this.color.getSelectedIndex();
        this.textframe.setForeground(drawData.getColor(id));
        if (this.text != null) {
            this.text.color = id;
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    class FontPanel
    extends JPanel {
        Font thisFont = new Font("Arial", 0, 10);

        public void changeFont(String f, int st, String si) {
            Integer newSize = new Integer(si);
            int size = newSize;
            this.thisFont = new Font(f, st, size);
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setColor(Color.darkGray);
            g2.setFont(this.thisFont);
            String change = "Pick a font, size, and style to change me";
            FontMetrics metrics = g2.getFontMetrics();
            int width = metrics.stringWidth(change);
            int height = metrics.getHeight();
            g2.drawString(change, w / 2 - width / 2, h / 2 - height / 2);
        }
    }
}

