/*
 * Decompiled with CFR 0.152.
 */
package wprover;

import java.util.Vector;
import wprover.CAsistLine;
import wprover.CLine;
import wprover.CPoint;
import wprover.CTransform;
import wprover.CharSet;
import wprover.Circle;
import wprover.Coord;
import wprover.GeoCond;
import wprover.GeoPoly;
import wprover.Hypo;
import wprover.Input;
import wprover.TMono;
import wprover.TPoly;
import wprover.Thm;
import wprover.param;

public class mainProcess {
    private static GeoPoly poly = GeoPoly.getPoly();
    private static Input in = Input.getInstance();
    private static CharSet charset = CharSet.getinstance();
    String fN;
    Thm thisThm;
    int movingpoint = -1;
    CTransform trans = new CTransform();
    CPoint[] points;
    param[] parameter;
    int pointsCounter;
    Vector lines = new Vector();
    Vector circles = new Vector();
    Vector assistline = new Vector();
    TPoly polynomials;
    TPoly conclutions;
    boolean isOptmized = false;
    int firstTime = 0;
    static final double EPS = 0.001;
    static final int PICEPS = 20;
    TMono second_pp = null;

    CTransform gettrans() {
        return this.trans;
    }

    int getstatus() {
        return this.firstTime;
    }

    String[] getReadingThmName() {
        return in.getthmname();
    }

    public boolean read_input() {
        try {
            in.read_input(this.fN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void printPoly(TPoly p) {
        while (p != null) {
            poly.printpoly(p.getPoly());
            p = p.getNext();
        }
    }

    public boolean generate() {
        TPoly ps1 = null;
        TPoly pp = ps1 = this.gen_polys(this.thisThm);
        this.printPoly(ps1);
        ps1 = this.polynomials = charset.charset(pp);
        System.out.println("charset output: ............");
        this.printPoly(ps1);
        boolean result = this.prove(this.conclutions.getPoly(), this.polynomials);
        return true;
    }

    public boolean prove(TMono tp, TPoly ps3) {
        System.out.println("proving output........");
        System.out.println("conclution is ...:  ");
        poly.pr(tp);
        ps3 = charset.reverse(ps3);
        int i = 0;
        while (ps3 != null) {
            System.out.print("f" + i + ": ");
            poly.pr(ps3.getPoly());
            tp = poly.prem(tp, ps3.getPoly());
            System.out.print("r" + i + ": ");
            poly.pr(tp);
            ps3 = ps3.getNext();
            ++i;
        }
        int result = poly.plength(tp);
        return result == 0;
    }

    public boolean isNear(double x, double y) {
        int prno = -1;
        double distance = -1.0;
        for (int i = 0; i < this.pointsCounter; ++i) {
            double x1 = this.points[i].getx();
            double y1 = this.points[i].gety();
            if (!this.points[i].x1.Solved || !this.points[i].x1.Solved) continue;
            double len = Math.pow(x - x1, 2.0) + Math.pow(y - y1, 2.0);
            if (!(distance < 0.0) && !(distance > len) || this.points[i].type == 3) continue;
            prno = i + 1;
            distance = len;
        }
        if (distance > 20.0 || distance < 0.0) {
            this.movingpoint = -1;
            return false;
        }
        this.movingpoint = prno;
        return true;
    }

    public boolean updateLocation(double x, double y) {
        if (this.firstTime != 0) {
            if (this.firstTime == 1) {
                int n = -1;
                for (int i = 0; i < this.pointsCounter; ++i) {
                    if (this.points[i].x1.Solved || this.points[i].y1.Solved) continue;
                    if (this.points[i].type == 3) break;
                    this.points[i].x1.value = x;
                    this.points[i].y1.value = y;
                    this.points[i].x1.Solved = true;
                    this.points[i].y1.Solved = true;
                    if (i != 1) break;
                    this.rtranALl();
                    break;
                }
                this.reCalculate(true);
                if (this.parameter[this.pointsCounter * 2 - 1].Solved) {
                    this.firstTime = 2;
                }
            } else if (this.movingpoint != -1) {
                CPoint p = this.points[this.movingpoint - 1];
                p.x1.value = x;
                p.y1.value = y;
                if (this.movingpoint == 1 || this.movingpoint == 2) {
                    this.rtranALl();
                }
                this.reCalculate(false);
            }
        }
        return true;
    }

    public boolean reCalculate(boolean Step) {
        for (TPoly tp = this.polynomials; tp != null; tp = tp.getNext()) {
            TMono m = tp.getPoly();
            int lva = poly.lv(m);
            if (this.parameter[lva - 2].Solved) {
                int t = (lva - 1) / 2;
                if (this.points[t].type == 2 && this.points[t].OnCircleOrOnLine != 0) {
                    this.half_decide(this.points[t], this.points[t].x1.value, this.points[t].y1.value);
                    continue;
                }
                this.parameter[lva - 1].value = poly.calculv(m, this.parameter)[0];
                if (this.parameter[lva - 1].Solved) continue;
                this.parameter[lva - 1].Solved = true;
                if (lva % 2 != 0 || !Step) continue;
                break;
            }
            return false;
        }
        return true;
    }

    public boolean SetAttr() {
        for (TPoly tp = this.polynomials; tp != null; tp = tp.getNext()) {
            int lva = poly.lv(tp.getPoly());
            this.parameter[lva - 1].type = 1;
        }
        for (int i = 0; i < this.pointsCounter; ++i) {
            int type1 = this.points[i].x1.type;
            int type2 = this.points[i].y1.type;
            this.points[i].type = type1 == 1 && type2 == 1 ? 3 : (type1 == 0 && type2 == 0 ? 1 : 2);
        }
        return true;
    }

    public void pc() {
        int i = 0;
        while (i < this.pointsCounter) {
            if (this.points[i].type != 2) continue;
            String string = this.points[i].name;
        }
    }

    TMono geo_poly(Hypo hp, Coord[] pts, int coordn, boolean isconclution) {
        char[] cond = hp.cond;
        int[] x = new int[6];
        int[] y = new int[6];
        String name = null;
        int i = 0;
        while (true) {
            name = new String(hp.pts[i]);
            if ((name = name.trim()).length() == 0) break;
            for (int j = 0; j < this.pointsCounter; ++j) {
                if (name.compareTo(this.points[j].name) != 0) continue;
                x[i] = this.points[j].x1.xindex;
                y[i] = this.points[j].y1.xindex;
                break;
            }
            ++i;
        }
        block13: for (i = 0; i < GeoCond.geocondnum; ++i) {
            if (!GeoCond.eqword(cond, GeoCond.geocond[i].toCharArray())) continue;
            switch (i) {
                case 0: 
                case 1: {
                    for (int k = 0; k < 3; ++k) {
                        for (int n = 0; n < 3; ++n) {
                            if (n == k || x[k] <= x[n]) continue;
                            int t = x[k];
                            x[k] = x[n];
                            x[n] = t;
                            t = y[k];
                            y[k] = y[n];
                            y[n] = t;
                        }
                    }
                    CLine ln = this.addline(x[1], y[1], x[2], y[2]);
                    if (ln != null) {
                        ln.onLine(this.getpt(x[0]));
                    }
                    if (isconclution) {
                        ln.setColorType("conclution");
                    }
                    return poly.collinear(x[0], y[0], x[1], y[1], x[2], y[2]);
                }
                case 2: 
                case 3: {
                    CLine ln1 = this.addline(x[0], y[0], x[1], y[1]);
                    CLine ln2 = this.addline(x[2], y[2], x[3], y[3]);
                    if (isconclution) {
                        ln1.setColorType("conclution");
                        ln2.setColorType("conclution");
                    }
                    return poly.parallel(x[0], y[0], x[1], y[1], x[2], y[2], x[3], y[3]);
                }
                case 4: 
                case 5: {
                    CLine line1 = this.addline(x[0], y[0], x[1], y[1]);
                    CLine line2 = this.addline(x[2], y[2], x[3], y[3]);
                    if (isconclution) {
                        line1.setColorType("conclution");
                        line2.setColorType("conclution");
                    }
                    return poly.perpendicular(x[0], y[0], x[1], y[1], x[2], y[2], x[3], y[3]);
                }
                case 6: 
                case 7: {
                    int n = -1;
                    int m = -1;
                    for (i = 0; i < 4; ++i) {
                        int j;
                        boolean is = false;
                        for (j = i + 1; j < 4; ++j) {
                            if (x[i] != x[j] || y[i] != y[j]) continue;
                            is = true;
                            break;
                        }
                        if (!is) continue;
                        for (int k = 0; k < 4; ++k) {
                            if (k == i || k == j) continue;
                            if (m < 0) {
                                m = k;
                                continue;
                            }
                            n = k;
                        }
                        break;
                    }
                    Circle c = this.addcircl(x[i], y[i], x[m], y[m]);
                    c.addPoint(this.getpt(x[n]));
                    c.setType(1);
                    CLine line1 = this.addline(x[i], y[i], x[m], y[m]);
                    CLine line2 = this.addline(x[i], y[i], x[n], y[n]);
                    if (isconclution) {
                        line1.setColorType("conclution");
                        line2.setColorType("conclution");
                    }
                    CPoint pt = this.getpt(x[i]);
                    if (pt.x1.xindex > x[m] && pt.y1.xindex > x[n]) {
                        pt.OnCircleOrOnLine = 3;
                        CAsistLine aline = new CAsistLine(this.getpt(x[m]), this.getpt(x[n]), 0);
                        aline.addpoint(pt);
                        this.assistline.add(aline);
                    }
                    return poly.eqdistance(x[0], y[0], x[1], y[1], x[2], y[2], x[3], y[3]);
                }
                case 8: {
                    Circle c = this.addcircl(x[0], y[0], x[1], y[1]);
                    c.addPoint(this.getpt(x[2]));
                    c.setType(1);
                    if (x[0] > x[1] && x[0] > x[2]) {
                        CPoint pt = this.getpt(x[0]);
                        pt.OnCircleOrOnLine = 3;
                        CAsistLine aline = new CAsistLine(this.getpt(x[1]), this.getpt(x[2]), 0);
                        aline.addpoint(pt);
                        this.assistline.add(aline);
                    }
                    return poly.eqdistance(x[0], y[0], x[1], y[1], x[0], y[0], x[2], y[2]);
                }
                case 9: {
                    CLine ln = this.addline(x[0], y[0], x[2], y[2]);
                    if (isconclution) {
                        ln.setColorType("conclution");
                    } else {
                        ln.onLine(this.getpt(x[1]));
                    }
                    this.second_pp = poly.midpoint(y[0], y[1], y[2]);
                    return poly.midpoint(x[0], x[1], x[2]);
                }
                case 13: {
                    Circle c = x[0] == x[1] ? this.addcircl(x[0], y[0], x[2], y[2]) : this.addcircl(x[0], y[0], x[1], y[1]);
                    if (isconclution) {
                        c.setType(4);
                    } else {
                        c.setType(2);
                    }
                    c = x[3] == x[4] ? this.addcircl(x[3], y[3], x[5], y[5]) : this.addcircl(x[3], y[3], x[4], y[4]);
                    if (isconclution) {
                        c.setType(4);
                        continue block13;
                    }
                    c.setType(2);
                    continue block13;
                }
                case 11: 
                case 12: {
                    System.out.print("Cond 11-12 is to be implemented\n");
                    continue block13;
                }
                case 10: {
                    this.addline(x[0], y[1], x[1], y[1]);
                    this.addline(x[1], y[1], x[2], y[2]);
                    this.addline(x[3], y[3], x[4], y[4]);
                    this.addline(x[4], y[4], x[5], y[5]);
                    return poly.eqangle(x[0], y[0], x[1], y[1], x[2], y[2], x[3], y[3], x[4], y[4], x[5], y[5]);
                }
                default: {
                    System.out.print("unrecognized geometry condition\n");
                }
            }
        }
        System.out.print("unrecognized geometry condition\n");
        return null;
    }

    TPoly gen_polys(Thm ptr) {
        boolean j = false;
        TPoly ps = null;
        int num = ptr.hypon;
        for (int i = 0; i <= num; ++i) {
            TMono pp = i < num ? this.geo_poly(ptr.hp[i], ptr.pts, ptr.coordn, false) : this.geo_poly(ptr.hp[i], ptr.pts, ptr.coordn, true);
        }
        return ps;
    }

    TMono collinear0(Hypo hp, Coord[] pts, int coordn) {
        int[] x = new int[3];
        int[] y = new int[3];
        for (int i = 0; i < 3; ++i) {
            x[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 1);
            y[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 0);
        }
        CLine ln = this.addline(x[1], y[1], x[2], y[2]);
        if (ln != null) {
            ln.onLine(this.getpt(x[0]));
        }
        return poly.collinear(x[0], y[0], x[1], y[1], x[2], y[2]);
    }

    TMono parallel0(Hypo hp, Coord[] pts, int coordn) {
        int[] x = new int[4];
        int[] y = new int[4];
        for (int i = 0; i < 4; ++i) {
            x[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 1);
            y[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 0);
        }
        this.addline(x[0], y[0], x[1], y[1]);
        this.addline(x[2], y[2], x[3], y[3]);
        return poly.parallel(x[0], y[0], x[1], y[1], x[2], y[2], x[3], y[3]);
    }

    TMono perpendicular0(Hypo hp, Coord[] pts, int coordn) {
        int[] x = new int[4];
        int[] y = new int[4];
        for (int i = 0; i < 4; ++i) {
            x[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 1);
            y[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 0);
        }
        this.addline(x[0], y[0], x[1], y[1]);
        this.addline(x[2], y[2], x[3], y[3]);
        return poly.perpendicular(x[0], y[0], x[1], y[1], x[2], y[2], x[3], y[3]);
    }

    TMono eqdistance0(Hypo hp, Coord[] pts, int coordn) {
        int i;
        int[] x = new int[4];
        int[] y = new int[4];
        for (i = 0; i < 4; ++i) {
            x[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 1);
            y[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 0);
        }
        for (i = 0; i < 4; ++i) {
            int j;
            boolean is = false;
            for (j = i + 1; j < 4; ++j) {
                if (x[i] != x[j] || y[i] != y[j]) continue;
                is = true;
                break;
            }
            if (!is) continue;
            Circle c = null;
            for (int k = 0; k < 4; ++k) {
                if (k == i || k == j) continue;
                if (c == null) {
                    c = this.addcircl(x[i], y[i], x[k], y[k]);
                    continue;
                }
                c.addPoint(this.getpt(x[k]));
            }
            break;
        }
        return poly.eqdistance(x[0], y[0], x[1], y[1], x[2], y[2], x[3], y[3]);
    }

    CPoint getpt(int index) {
        return this.points[index / 2];
    }

    TMono perp_bisect0(Hypo hp, Coord[] pts, int coordn) {
        int[] x = new int[3];
        int[] y = new int[3];
        for (int i = 0; i < 3; ++i) {
            x[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 1);
            y[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 0);
        }
        return poly.eqdistance(x[0], y[0], x[1], y[1], x[0], y[0], x[2], y[2]);
    }

    TMono eqangle0(Hypo hp, Coord[] pts, int coordn) {
        int[] x = new int[6];
        int[] y = new int[6];
        for (int i = 0; i < 6; ++i) {
            x[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 1);
            y[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 0);
        }
        return poly.eqangle(x[0], y[0], x[1], y[1], x[2], y[2], x[3], y[3], x[4], y[4], x[5], y[5]);
    }

    TMono midpoint0(Hypo hp, Coord[] pts, int coordn) {
        int[] x = new int[3];
        int[] y = new int[3];
        for (int i = 0; i < 3; ++i) {
            x[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 1);
            y[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 0);
        }
        CLine ln = this.addline(x[0], y[0], x[2], y[2]);
        ln.onLine(this.getpt(x[1]));
        this.second_pp = poly.midpoint(y[0], y[1], y[2]);
        return poly.midpoint(x[0], x[1], x[2]);
    }

    TMono c_c_tangent_sv(Hypo hp, Coord[] pts, int coordn) {
        int[] xx = new int[6];
        int[] yy = new int[6];
        for (int i = 0; i < 6; ++i) {
            xx[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 1);
            yy[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 0);
        }
        TMono x = poly.sqdistance(xx[0], yy[0], xx[1], yy[1]);
        TMono y = poly.sqdistance(xx[2], yy[2], xx[3], yy[3]);
        TMono z = poly.sqdistance(xx[4], yy[4], xx[5], yy[5]);
        TMono x1 = poly.sqdistance(xx[0], yy[0], xx[1], yy[1]);
        TMono y1 = poly.sqdistance(xx[2], yy[2], xx[3], yy[3]);
        TMono z1 = poly.sqdistance(xx[4], yy[4], xx[5], yy[5]);
        TMono s = poly.pdif(x, y);
        TMono s1 = poly.pdif(x, y);
        s = poly.ptimes(s, s1);
        x1 = poly.pctimes(x1, -2);
        y1 = poly.pctimes(y1, -2);
        TMono r = poly.padd(poly.padd(x1, y1), z1);
        r = poly.ptimes(z, r);
        return poly.padd(s, r);
    }

    TMono c_c_tangent0(Hypo hp, Coord[] pts, int coordn) {
        int[] xx = new int[6];
        int[] yy = new int[6];
        for (int i = 0; i < 6; ++i) {
            xx[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 1);
            yy[i] = this.getxy(new String(hp.pts[i]), pts, coordn, 0);
        }
        TMono x = poly.sqdistance(xx[0], yy[0], xx[5], yy[5]);
        TMono y = poly.sqdistance(xx[1], yy[1], xx[2], yy[2]);
        TMono z = poly.sqdistance(xx[4], yy[4], xx[3], yy[3]);
        TMono x1 = poly.sqdistance(xx[0], yy[0], xx[5], yy[5]);
        TMono y1 = poly.sqdistance(xx[1], yy[1], xx[2], yy[2]);
        TMono z1 = poly.sqdistance(xx[4], yy[4], xx[3], yy[3]);
        TMono s = poly.pdif(x, y);
        TMono s1 = poly.pdif(x, y);
        s = poly.ptimes(s, s1);
        x1 = poly.pctimes(x1, -2);
        y1 = poly.pctimes(y1, -2);
        TMono r = poly.padd(poly.padd(x1, y1), z1);
        r = poly.ptimes(z, r);
        return poly.padd(s, r);
    }

    int getxy(String point, Coord[] pts, int coordn, int x) {
        point = point.trim();
        if (this.isOptmized) {
            for (int i = 0; i <= coordn; ++i) {
                if (point.compareTo(new String(pts[i].getPt())) != 0) continue;
                if (x == 0) {
                    return pts[i].getY();
                }
                return pts[i].getX();
            }
            System.out.println("Error of the theorem input: point" + point + " has not been assigned coordinators");
        } else {
            for (int i = 0; i < this.pointsCounter; ++i) {
                if (point.compareTo(this.points[i].name) != 0) continue;
                if (x == 0) {
                    return this.points[i].y1.xindex;
                }
                return this.points[i].x1.xindex;
            }
            System.out.println("Error of the theorem input: point" + point + " has not been assigned coordinators");
        }
        return -1;
    }

    public void cleanVariables() {
        this.movingpoint = -1;
        this.points = null;
        this.parameter = null;
        this.pointsCounter = -1;
        this.lines.clear();
        this.circles.clear();
        this.assistline.clear();
        this.polynomials = null;
        this.conclutions = null;
        this.firstTime = 0;
    }

    public boolean setvarable(String thm) {
        this.thisThm = in.getThm(thm);
        if (this.thisThm == null) {
            return false;
        }
        this.cleanVariables();
        Thm ptr = this.thisThm;
        int len = ptr.coordn;
        int counter = 1;
        this.pointsCounter = len + 1;
        System.out.println(this.thisThm.thname);
        this.parameter = new param[this.pointsCounter * 2];
        this.points = new CPoint[this.pointsCounter];
        for (int i = 0; i < this.pointsCounter; ++i) {
            String name = new String(ptr.pts[i].getPt());
            param x1 = new param(counter, -1);
            param y1 = new param(counter + 1, -1);
            counter += 2;
            this.parameter[i * 2] = x1;
            this.parameter[i * 2 + 1] = y1;
            this.points[i] = new CPoint(name, x1, y1);
        }
        this.trans.setTrans(0.0, 0.0, 0.0, 1.0);
        return true;
    }

    public void rtranALl() {
        double y;
        double x;
        for (int i = 0; i < this.pointsCounter && this.points[i].x1.Solved && this.points[i].y1.Solved; ++i) {
            x = this.points[i].x1.value;
            y = this.points[i].y1.value;
            this.points[i].x1.value = this.trans.transLWX(x, y);
            this.points[i].y1.value = this.trans.transLWY(x, y);
        }
        double tx = this.parameter[0].value;
        double ty = this.parameter[1].value;
        double dx = this.parameter[2].value - tx;
        double dy = this.parameter[3].value - ty;
        double dl = Math.sqrt(dx * dx + dy * dy);
        double cos = dx / dl;
        double sin = dy / dl;
        CTransform T = new CTransform();
        T.setTrans(tx, ty, sin, cos);
        for (int i = 0; i < this.pointsCounter && this.points[i].x1.Solved && this.points[i].y1.Solved; ++i) {
            x = this.points[i].x1.value;
            y = this.points[i].y1.value;
            this.points[i].x1.value = T.transWLX(x, y);
            this.points[i].y1.value = T.transWLY(x, y);
        }
        this.trans = T;
    }

    public CLine addline(int x1, int y1, int x2, int y2) {
        int counter = 0;
        CLine line = null;
        for (int i = 0; i < this.lines.size(); ++i) {
            counter = 0;
            CLine ln = (CLine)this.lines.get(i);
            for (int j = 0; j < ln.points.size(); ++j) {
                CPoint p = (CPoint)ln.points.get(j);
                if (p.isEqual(x1, y1) || p.isEqual(x2, y2)) {
                    ++counter;
                }
                if (counter != 2) continue;
                line = ln;
                break;
            }
            if (counter != 2) continue;
            return line;
        }
        line = new CLine(this.points[x1 / 2], this.points[x2 / 2]);
        this.lines.add(line);
        return line;
    }

    public Circle addcircl(int x1, int y1, int x2, int y2) {
        Circle cir = null;
        for (int i = 0; i < this.circles.size(); ++i) {
            Circle c = (Circle)this.circles.get(i);
            if (x1 == c.o.x1.xindex && y1 == c.o.y1.xindex) {
                for (int j = 0; j < c.points.size(); ++j) {
                    CPoint p = (CPoint)c.points.get(j);
                    if (p.x1.xindex != x2 || p.y1.xindex != y2) continue;
                    cir = c;
                    break;
                }
            }
            if (cir != null) break;
        }
        if (cir != null) {
            return cir;
        }
        cir = new Circle(this.getpt(x1), this.getpt(x2));
        this.circles.add(cir);
        return cir;
    }

    public boolean half_decide(CPoint point, double x, double y) {
        if (point.OnCircleOrOnLine == 2) {
            double x1;
            Circle cir = null;
            CPoint ac = null;
            for (int i = 0; i < this.circles.size(); ++i) {
                Circle c = (Circle)this.circles.get(i);
                for (int j = 0; j < c.points.size(); ++j) {
                    CPoint p = (CPoint)c.points.get(j);
                    if (p == point) {
                        cir = c;
                        continue;
                    }
                    if (!p.x1.Solved || !p.y1.Solved || p.x1.xindex >= point.x1.xindex) continue;
                    ac = p;
                }
                if (cir != null) break;
            }
            if (cir == null || ac == null) {
                return false;
            }
            double xT = ac.x1.value;
            double yT = ac.y1.value;
            double xo = cir.o.x1.value;
            double yo = cir.o.y1.value;
            double R = Math.sqrt((xo - xT) * (xo - xT) + (yo - yT) * (yo - yT));
            double R1 = Math.sqrt((xo - x) * (xo - x) + (yo - y) * (yo - y));
            double y1 = yo + (y - yo) * R / R1;
            point.x1.value = x1 = xo + (x - xo) * R / R1;
            point.x1.Solved = true;
            point.y1.value = y1;
            point.y1.Solved = true;
            return true;
        }
        if (point.OnCircleOrOnLine == 3) {
            if (!point.x1.Solved || !point.y1.Solved) {
                return false;
            }
            CAsistLine ln = null;
            for (int i = 0; i < this.assistline.size(); ++i) {
                CAsistLine line = (CAsistLine)this.assistline.get(i);
                for (int j = 0; j < line.points.size(); ++j) {
                    CPoint p = (CPoint)line.points.get(j);
                    if (!point.isEqual(p)) continue;
                    ln = line;
                    break;
                }
                if (ln != null) break;
            }
            if (ln == null) {
                return false;
            }
            ln.calculate_half(point);
            return true;
        }
        if (point.OnCircleOrOnLine == 1) {
            double yt;
            double xt;
            CPoint pnt2 = null;
            CPoint pnt1 = null;
            CPoint pnt = null;
            for (int i = 0; i < this.lines.size(); ++i) {
                CLine line = (CLine)this.lines.get(i);
                pnt2 = null;
                pnt1 = null;
                for (int j = 0; j < line.points.size(); ++j) {
                    CPoint pt = (CPoint)line.points.get(j);
                    if (point.isEqual(pt)) {
                        pnt = pt;
                        continue;
                    }
                    if (pt.type != 1) continue;
                    if (pnt1 == null) {
                        pnt1 = pt;
                        continue;
                    }
                    pnt2 = pt;
                }
                if (pnt != null) break;
            }
            if (pnt1 == null || pnt2 == null) {
                return false;
            }
            double x1 = pnt1.x1.value;
            double y1 = pnt1.y1.value;
            double x2 = pnt2.x1.value;
            double y2 = pnt2.y1.value;
            double x3 = point.x1.value;
            double y3 = point.y1.value;
            if (Math.abs(x2 - x1) < 0.001) {
                xt = x1;
                yt = y3;
            } else {
                double xd = x2 - x1;
                double yd = y2 - y1;
                xt = ((y3 - y1) * yd * xd + x1 * yd * yd + x3 * xd * xd) / (xd * xd + yd * yd);
                yt = y1 + (xt - x1) * yd / xd;
            }
            point.x1.value = xt;
            point.y1.value = yt;
            point.x1.Solved = true;
            point.y1.Solved = true;
        } else {
            System.out.println("undefined half decide type!");
        }
        return false;
    }
}

