/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Live
extends Applet
implements Runnable {
    Parser parser;
    Graphics3D ps3D;
    Graphics3D painted_ps3D;
    Vector frames;
    int current_frame_index;
    double animation_display_time = 0.05;
    int animation_direction = 1;
    long painted_time;
    boolean is_animating = true;
    boolean is_spinning = false;
    int spin_x = 0;
    int spin_y = 0;
    Thread painter = null;
    Image image_buffer;
    Graphics graphics_buffer;
    Image second_image_buffer;
    Graphics second_graphics_buffer;
    Image preload_bg_image;
    Image bg_image;
    Image bg_rotated_image;
    Image bg_right_image;
    Image bg_rotated_right_image;
    int bg_width;
    int bg_height;
    boolean bg_is_fixed;
    boolean bg_is_cylindrical;
    boolean bg_is_spherical;
    Color background_color;
    Color foreground_color;
    Color point_edge_color;
    boolean is_put_on_screen = true;
    int min_height_width = 100;
    Primitive3D active_primitive = null;
    int text_x = 10;
    int text_y = 0;
    int applet_width;
    int applet_height;
    boolean is_dragging;
    int visible_faces;
    AudioClip audio_enter;
    AudioClip audio_loop_enter;
    AudioClip audio_first_frame;
    static String empty_string = "";
    static String enter_string = "LiveGraphics3D -0.70: Please drag to rotate.";
    static String enter_init_string = "Initializing LiveGraphics3D -0.70. Please wait.";
    static String syntax_error_string = "LiveGraphics3D applet stopped because of a syntax error.";
    static String url_error_string = "Malformed URL: ";
    static String equal_sign_string = "=";
    int down_mouse_x;
    int down_mouse_y;
    long down_time;
    int last_x;
    int last_y;
    long last_drag_time;
    int llast_x;
    int llast_y;
    long llast_drag_time;
    boolean is_control_down;
    boolean is_meta_down;
    boolean is_shift_down;
    boolean is_mouse_here;
    double length_view_point_factor;
    double magnification_factor;
    int cut_primitives_count;
    Quaternion rotation;
    int bg_x_offset;
    int bg_y_offset;
    boolean is_stereo;
    double stereo_distance;
    double preceding_length_view_point_factor;
    double preceding_magnification_factor;
    int preceding_cut_primitives_count;
    Quaternion preceding_rotation;
    int preceding_bg_x_offset;
    int preceding_bg_y_offset;
    double preceding_stereo_distance;
    int preceding_frame_index;
    boolean is_new_dragging;
    boolean initialized;

    public void init() {
    }

    public void initialize() {
        if (!this.initialized) {
            String input_text;
            int label_index;
            String string_pecolor;
            String string_audio_first_frame;
            String string_audio_loop_enter;
            String string_audio_enter;
            block86: {
                String string_bgcolor;
                System.out.println("LiveGraphics3D -0.70 by Martin_Kraus_Germany@yahoo.com");
                InputStream logo_stream = this.getClass().getResourceAsStream("liveinit.gif");
                Image logo_image = null;
                if (logo_stream != null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    try {
                        int logo_size = 4000;
                        byte[] logo_bytes = new byte[logo_size];
                        logo_stream.read(logo_bytes, 0, logo_size);
                        logo_image = toolkit.createImage(logo_bytes);
                        logo_bytes = null;
                    }
                    catch (IOException iOException) {}
                    if (logo_image != null) {
                        MediaTracker tracker = new MediaTracker(this);
                        tracker.addImage(logo_image, 0);
                        try {
                            tracker.waitForAll();
                        }
                        catch (InterruptedException interruptedException) {}
                        tracker = null;
                    }
                }
                if ((string_bgcolor = this.getParameter("BGCOLOR")) != null) {
                    if ((string_bgcolor = string_bgcolor.trim()).charAt(0) == '#') {
                        string_bgcolor = string_bgcolor.substring(1);
                    }
                    this.background_color = new Color(Integer.parseInt(string_bgcolor, 16));
                    this.foreground_color = this.background_color.getRed() + this.background_color.getBlue() + this.background_color.getGreen() > 384 ? Color.black : Color.white;
                } else {
                    this.background_color = Color.white;
                    this.foreground_color = Color.black;
                }
                this.set_applet_size();
                this.image_buffer = this.createImage(this.applet_width, this.applet_height);
                this.graphics_buffer = this.image_buffer.getGraphics();
                this.graphics_buffer.setFont(new Font("Dialog", 0, 10));
                if (logo_image == null) {
                    this.graphics_buffer.setColor(this.background_color);
                    this.graphics_buffer.fillRect(0, 0, this.applet_width, this.applet_height);
                    this.print_message(this.graphics_buffer, "LiveGraphics3D -0.70", false);
                    this.print_message(this.graphics_buffer, "Initializing. Please wait.", false);
                } else {
                    this.graphics_buffer.setColor(Color.white);
                    this.graphics_buffer.fillRect(0, 0, this.applet_width, this.applet_height);
                    this.graphics_buffer.drawImage(logo_image, (this.applet_width - logo_image.getWidth(null)) / 2, (this.applet_height - logo_image.getHeight(null)) / 2, null);
                    logo_image = null;
                }
                this.is_put_on_screen = false;
                this.repaint();
                String string_preload_background = this.getParameter("PRELOAD_BACKGROUND");
                if (string_preload_background != null) {
                    try {
                        this.preload_bg_image = this.getImage(new URL(this.getDocumentBase(), string_preload_background));
                        if (this.preload_bg_image == null) break block86;
                        MediaTracker tracker = new MediaTracker(this);
                        tracker.addImage(this.preload_bg_image, 0);
                        try {
                            tracker.waitForAll();
                        }
                        catch (InterruptedException interruptedException) {}
                        tracker = null;
                        this.graphics_buffer.drawImage(this.preload_bg_image, 0, 0, this.applet_width, this.applet_height, null);
                        this.repaint();
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            if ((string_audio_enter = this.getParameter("AUDIO_ENTER")) != null) {
                this.audio_enter = this.getAudioClip(this.getDocumentBase(), string_audio_enter);
            }
            if ((string_audio_loop_enter = this.getParameter("AUDIO_LOOP_ENTER")) != null) {
                this.audio_loop_enter = this.getAudioClip(this.getDocumentBase(), string_audio_loop_enter);
            }
            if ((string_audio_first_frame = this.getParameter("AUDIO_FIRST_FRAME")) != null) {
                this.audio_first_frame = this.getAudioClip(this.getDocumentBase(), string_audio_first_frame);
            }
            if ((string_pecolor = this.getParameter("POINT_EDGE_COLOR")) != null) {
                if ((string_pecolor = string_pecolor.trim()).charAt(0) == '#') {
                    string_pecolor = string_pecolor.substring(1);
                }
                this.point_edge_color = new Color(Integer.parseInt(string_pecolor, 16));
            } else {
                this.point_edge_color = null;
            }
            double initial_phi = 0.0;
            double initial_theta = 0.0;
            String string_initial_rotation = this.getParameter("INITIAL_ROTATION");
            if (string_initial_rotation != null && !Character.isDigit(string_initial_rotation.charAt(0))) {
                String URLref = this.getDocumentBase().getRef();
                string_initial_rotation = string_initial_rotation.concat("=");
                string_initial_rotation = URLref == null || (label_index = URLref.indexOf(string_initial_rotation)) < 0 ? null : URLref.substring(label_index + string_initial_rotation.length());
            }
            if (string_initial_rotation != null) {
                try {
                    initial_phi = Double.valueOf(string_initial_rotation);
                    label_index = string_initial_rotation.indexOf(",");
                    if (label_index > 0 && (string_initial_rotation.indexOf(equal_sign_string) < 0 || label_index < string_initial_rotation.indexOf(equal_sign_string))) {
                        initial_theta = Double.valueOf(string_initial_rotation.substring(label_index + 1));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("LiveGraphics3D error: Could not parse INITIAL_ROTATION specification \"" + this.getParameter("INITIAL_ROTATION") + "\"");
                    initial_phi = 0.0;
                    initial_theta = 0.0;
                }
            }
            String string_spin_x = this.getParameter("SPIN_X");
            this.spin_x = 0;
            if (string_spin_x != null) {
                try {
                    this.spin_x = Double.valueOf(string_spin_x).intValue();
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String string_spin_y = this.getParameter("SPIN_Y");
            this.spin_y = 0;
            if (string_spin_y != null) {
                try {
                    this.spin_y = Double.valueOf(string_spin_y).intValue();
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (this.spin_x != 0 || this.spin_y != 0) {
                this.is_spinning = true;
            }
            String string_visible_faces = this.getParameter("VISIBLE_FACES");
            this.visible_faces = 3;
            if (string_visible_faces != null) {
                if (string_visible_faces.equalsIgnoreCase("FRONT")) {
                    this.visible_faces = 1;
                } else if (string_visible_faces.equalsIgnoreCase("BACK")) {
                    this.visible_faces = 2;
                }
            }
            if ((input_text = this.getParameter("INPUT")) == null) {
                String string_input_archive = this.getParameter("INPUT_ARCHIVE");
                String string_input_file = this.getParameter("INPUT_FILE");
                if (string_input_file != null) {
                    try {
                        InputStream input_stream = null;
                        if (string_input_archive != null) {
                            try {
                                ZipInputStream archive_stream = new ZipInputStream(new URL(this.getDocumentBase(), string_input_archive).openStream());
                                ZipEntry archive_entry = null;
                                archive_entry = archive_stream.getNextEntry();
                                while (archive_entry != null && !string_input_file.equals(archive_entry.getName())) {
                                    archive_entry = archive_stream.getNextEntry();
                                }
                                if (archive_entry != null) {
                                    input_stream = archive_stream;
                                }
                            }
                            catch (IOException iOException) {}
                        }
                        if (input_stream == null) {
                            input_stream = new URL(this.getDocumentBase(), string_input_file).openStream();
                        }
                        int buffer_length = 20000;
                        byte[] buffer = new byte[buffer_length];
                        int read_bytes = buffer_length;
                        StringBuffer string_buffer = new StringBuffer();
                        while (read_bytes > -1) {
                            read_bytes = input_stream.read(buffer, 0, buffer_length);
                            if (read_bytes <= -1) continue;
                            string_buffer.append(new String(buffer, 0, 0, read_bytes));
                        }
                        buffer = null;
                        input_text = string_buffer.toString();
                        string_buffer = null;
                    }
                    catch (IOException iOException) {
                        this.print_message(this.graphics_buffer, "LiveGraphics3D error:");
                        this.print_message(this.graphics_buffer, "Can't read " + string_input_file);
                    }
                }
            }
            Parser parser = new Parser(input_text);
            if (parser.text != null && parser.scan_animation() && parser.scanned_frames != null && parser.scanned_frames.size() > 0) {
                String string_magnification;
                this.frames = parser.scanned_frames;
                this.animation_display_time = parser.scanned_AnimationDisplayTime;
                this.animation_direction = parser.scanned_AnimationDirection;
                parser = null;
                String string_background = this.getParameter("BACKGROUND");
                this.bg_is_fixed = false;
                this.bg_is_cylindrical = false;
                this.bg_is_spherical = false;
                if (string_background != null) {
                    this.bg_is_fixed = true;
                } else {
                    string_background = this.getParameter("CYLINDRICAL_BACKGROUND");
                    if (string_background != null) {
                        this.bg_is_cylindrical = true;
                    } else {
                        string_background = this.getParameter("SPHERICAL_BACKGROUND");
                        if (string_background != null) {
                            this.bg_is_spherical = true;
                        }
                    }
                }
                this.bg_image = null;
                this.bg_right_image = null;
                MediaTracker tracker = null;
                if (string_background != null) {
                    tracker = new MediaTracker(this);
                    try {
                        this.bg_image = this.getImage(new URL(this.getDocumentBase(), string_background));
                        if (this.bg_image != null) {
                            tracker.addImage(this.bg_image, 0);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.print_message(this.graphics_buffer, "LiveGraphics3D error:");
                        this.print_message(this.graphics_buffer, "bad URL " + string_background);
                        this.bg_image = null;
                        tracker = null;
                        this.bg_is_fixed = false;
                        this.bg_is_cylindrical = false;
                        this.bg_is_spherical = false;
                    }
                }
                if (this.bg_image != null && (string_background = this.getParameter("RIGHT_BACKGROUND")) != null) {
                    try {
                        this.bg_right_image = this.getImage(new URL(this.getDocumentBase(), string_background));
                        if (this.bg_right_image != null) {
                            tracker.addImage(this.bg_right_image, 0);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                this.magnification_factor = (string_magnification = this.getParameter("MAGNIFICATION")) != null ? Math.abs(Double.valueOf(string_magnification)) : 1.0;
                this.preceding_magnification_factor = this.magnification_factor;
                String string_stereo_distance = this.getParameter("STEREO_DISTANCE");
                if (string_stereo_distance != null) {
                    this.is_stereo = true;
                    this.stereo_distance = Double.valueOf(string_stereo_distance);
                } else {
                    this.stereo_distance = 0.05;
                    this.is_stereo = false;
                }
                this.preceding_stereo_distance = this.stereo_distance;
                int frame_index = 0;
                while (frame_index < this.frames.size()) {
                    this.ps3D = (Graphics3D)this.frames.elementAt(frame_index);
                    this.ps3D.setGlobalParameters(this.applet_width, this.applet_height, this.background_color, this.point_edge_color);
                    this.ps3D.preparePrimitives(this.graphics_buffer);
                    ++frame_index;
                }
                this.current_frame_index = 0;
                if (this.bg_image != null) {
                    if (tracker != null) {
                        try {
                            tracker.waitForAll();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.bg_width = this.bg_image.getWidth(null);
                    this.bg_height = this.bg_image.getHeight(null);
                    if (this.bg_width < this.applet_width || this.bg_height < this.applet_height) {
                        this.bg_is_fixed = true;
                        this.bg_is_cylindrical = false;
                        this.bg_is_spherical = false;
                    }
                    this.bg_x_offset = 0;
                    this.bg_y_offset = 0;
                    if (this.bg_is_spherical) {
                        this.bg_x_offset = (int)(-initial_phi * (double)this.bg_width / 2.0 / 180.0);
                        this.bg_y_offset = (int)(-initial_theta * (double)this.bg_height / 180.0);
                        this.bg_rotated_image = this.createRotatedImage(this.bg_image);
                        if (this.bg_right_image != null) {
                            this.bg_rotated_right_image = this.createRotatedImage(this.bg_right_image);
                        }
                    } else if (this.bg_is_cylindrical) {
                        this.bg_x_offset = (int)(-initial_phi * (double)this.bg_width / 2.0 / 180.0);
                        this.bg_y_offset = (int)(-initial_theta * (double)this.bg_width / 2.0 / 180.0);
                    }
                    if (this.bg_is_cylindrical || this.bg_is_spherical) {
                        this.rotation = this.adjust_bg_offsets();
                    }
                    if (this.bg_right_image == null) {
                        this.bg_right_image = this.bg_image;
                        this.bg_rotated_right_image = this.bg_rotated_image;
                    }
                }
                if (!this.bg_is_cylindrical && !this.bg_is_spherical) {
                    this.rotation = new Quaternion(initial_theta * Math.PI / 180.0, 1.0, 0.0, 0.0, false);
                    this.rotation.multiply(new Quaternion(initial_phi * Math.PI / 180.0, 0.0, 1.0, 0.0, false));
                }
                this.preceding_rotation = this.rotation;
                this.ps3D = (Graphics3D)this.frames.elementAt(this.current_frame_index);
                this.ps3D.setPerspective(this.ps3D.length_view_point, this.ps3D.initial_magnification * this.magnification_factor, this.is_stereo, this.stereo_distance);
                this.ps3D.setCutPrimitivesCount(this.cut_primitives_count, this.visible_faces);
                this.ps3D.setQuaternion(this.rotation.product(this.ps3D.initial_rotation));
                this.ps3D.projectPoints(false);
                this.is_put_on_screen = false;
                this.paintGraphics3D();
            } else {
                if (parser.text == null) {
                    this.print_message(this.graphics_buffer, "LiveGraphics3D error: applet parameter");
                    this.print_message(this.graphics_buffer, "\"INPUT\" or \"INPUT_FILE\" missing.");
                } else {
                    if (parser.text_index + 1 >= parser.text.length()) {
                        parser.text_index = parser.text.length() - 1;
                    }
                    if (parser.text_index > 30) {
                        this.print_message(this.graphics_buffer, "LiveGraphics3D syntax error:");
                        this.print_message(this.graphics_buffer, "..." + parser.text.substring(parser.text_index - 30, parser.text_index + 1));
                    } else {
                        this.print_message(this.graphics_buffer, "LiveGraphics3D syntax error:");
                        this.print_message(this.graphics_buffer, parser.text.substring(0, parser.text_index + 1));
                    }
                }
                this.ps3D = null;
            }
            parser = null;
            this.preload_bg_image = null;
            System.gc();
        }
        if (this.ps3D == null) {
            this.print_message(this.graphics_buffer, "LiveGraphics3D aborted.", false);
            this.repaint();
        }
        this.initialized = true;
    }

    public Image createRotatedImage(Image original) {
        int width = original.getWidth(null);
        int height = original.getHeight(null);
        Image rotated_image = this.createImage(width + 1, height + 1);
        Graphics rotated_graphics = rotated_image.getGraphics();
        rotated_graphics.drawImage(original, 0, 0, null);
        int y = 0;
        while (y < height / 2) {
            rotated_graphics.copyArea(0, y, width, 1, 0, height - y - y);
            rotated_graphics.copyArea(0, height - 1 - y, width, 1, 0, y - (height - 1 - y));
            ++y;
        }
        rotated_graphics.copyArea(0, height - (height / 2 - 1), width, height / 2, 0, -1);
        int x = 0;
        while (x < width / 2) {
            rotated_graphics.copyArea(x, 0, 1, height, width - x - x, 0);
            rotated_graphics.copyArea(width - 1 - x, 0, 1, height, x - (width - 1 - x), 0);
            ++x;
        }
        rotated_graphics.copyArea(width - (width / 2 - 1), 0, width / 2, height, -1, 0);
        rotated_graphics = null;
        return rotated_image;
    }

    public void start() {
        this.set_applet_size();
        this.is_control_down = false;
        this.is_meta_down = false;
        this.is_shift_down = false;
        this.is_new_dragging = false;
        this.is_put_on_screen = true;
        this.is_dragging = false;
        this.is_animating = true;
        this.down_time = System.currentTimeMillis() - 10000L;
        this.painter = new Thread(this);
        this.painter.start();
    }

    public void set_applet_size() {
        this.applet_width = this.size().width;
        this.applet_height = this.size().height;
        this.min_height_width = this.applet_height < this.applet_width ? this.applet_height : this.applet_width;
    }

    public void print_message(Graphics g, String text) {
        this.print_message(g, text, true);
    }

    public void print_message(Graphics g, String text, boolean into_console) {
        if (into_console) {
            System.out.println(text);
        }
        this.text_y = this.text_y + g.getFontMetrics().getAscent() + 2;
        g.setColor(this.foreground_color);
        g.drawString(text, this.text_x, this.text_y);
    }

    public void stop() {
    }

    public void run() {
        this.initialize();
        while (this.ps3D != null) {
            boolean is_frame_old;
            if (this.is_new_dragging) {
                this.is_new_dragging = false;
                if (this.is_control_down) {
                    this.length_view_point_factor = this.preceding_length_view_point_factor * Math.pow(4.0, (double)(this.down_mouse_y - this.last_y) / (double)this.min_height_width);
                    this.stereo_distance = this.preceding_stereo_distance + 0.25 * (double)(this.last_x - this.down_mouse_x) / (double)this.applet_width;
                } else if (this.is_shift_down) {
                    this.magnification_factor = this.preceding_magnification_factor / Math.pow(4.0, (double)(this.down_mouse_y - this.last_y) / (double)this.min_height_width);
                    if (!this.bg_is_cylindrical && !this.bg_is_spherical) {
                        this.rotation = new Quaternion(4.71238898038469 * (double)(this.down_mouse_x - this.last_x) / (double)this.min_height_width, 0.0, 0.0, 1.0, false).product(this.preceding_rotation);
                    }
                } else if (this.is_meta_down) {
                    this.cut_primitives_count = this.preceding_cut_primitives_count - (this.down_mouse_y - this.last_y) / 8;
                    if (this.cut_primitives_count < 0) {
                        this.cut_primitives_count = 0;
                    }
                    int offset_frame_index = (this.last_x - this.down_mouse_x) / 8;
                    if (this.animation_direction == -1) {
                        offset_frame_index = -offset_frame_index;
                    }
                    this.current_frame_index = this.preceding_frame_index + offset_frame_index;
                    int frames_per_period = this.frames.size();
                    if (this.animation_direction == 0) {
                        frames_per_period = 2 * this.frames.size() - 2;
                    }
                    this.current_frame_index = this.current_frame_index >= 0 ? (this.current_frame_index %= frames_per_period) : (frames_per_period - -this.current_frame_index % frames_per_period) % frames_per_period;
                    this.ps3D = this.animation_direction == 0 ? (this.current_frame_index < this.frames.size() ? (Graphics3D)this.frames.elementAt(this.current_frame_index) : (Graphics3D)this.frames.elementAt(2 * this.frames.size() - this.current_frame_index - 2)) : (Graphics3D)this.frames.elementAt(this.current_frame_index);
                } else if (this.is_dragging || this.is_spinning) {
                    if (this.bg_is_cylindrical || this.bg_is_spherical) {
                        this.bg_x_offset = this.preceding_bg_x_offset - (this.last_x - this.down_mouse_x);
                        this.bg_y_offset = this.preceding_bg_y_offset - (this.last_y - this.down_mouse_y);
                        this.rotation = this.adjust_bg_offsets();
                    } else {
                        double nx = this.last_y - this.down_mouse_y;
                        double ny = this.last_x - this.down_mouse_x;
                        double abs = Math.sqrt(nx * nx + ny * ny);
                        this.rotation = abs > 1.0 ? new Quaternion(4.71238898038469 * abs / (double)this.min_height_width, nx /= abs, ny /= abs, 0.0, false).product(this.preceding_rotation) : this.preceding_rotation;
                    }
                }
                this.ps3D.setPerspective(this.ps3D.initial_length_view_point * this.length_view_point_factor, this.ps3D.initial_magnification * this.magnification_factor, this.is_stereo, this.stereo_distance);
                this.ps3D.setCutPrimitivesCount(this.cut_primitives_count, this.visible_faces);
                this.ps3D.setQuaternion(this.rotation.product(this.ps3D.initial_rotation));
                this.ps3D.projectPoints(false);
                if (!this.is_put_on_screen) {
                    while (!this.is_put_on_screen) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.is_put_on_screen = false;
                this.paintGraphics3D();
                if (this.audio_first_frame != null && this.current_frame_index == 0 && this.is_animating && this.frames.size() > 1 && (this.is_dragging || this.is_mouse_here)) {
                    this.audio_first_frame.play();
                }
            } else {
                try {
                    if (this.is_animating && this.frames.size() > 1 && (this.is_dragging || this.is_mouse_here) && !this.is_meta_down || this.is_spinning && this.is_mouse_here) {
                        Thread.sleep(5L);
                    } else {
                        Thread.sleep(20L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean bl = is_frame_old = System.currentTimeMillis() - this.painted_time >= (long)(1000.0 * this.animation_display_time);
            if (this.is_spinning && this.is_mouse_here && is_frame_old) {
                this.is_new_dragging = true;
                this.painted_time = System.currentTimeMillis();
                this.last_x += this.spin_x;
                this.last_y += this.spin_y;
            }
            if (!this.is_animating || this.frames.size() <= 1 || !this.is_dragging && !this.is_mouse_here || this.is_meta_down || !is_frame_old) continue;
            this.is_new_dragging = true;
            this.painted_time = System.currentTimeMillis();
            if (this.animation_direction == 1) {
                ++this.current_frame_index;
                if (this.current_frame_index >= this.frames.size()) {
                    this.current_frame_index = 0;
                }
                this.ps3D = (Graphics3D)this.frames.elementAt(this.current_frame_index);
                continue;
            }
            if (this.animation_direction == -1) {
                --this.current_frame_index;
                if (this.current_frame_index < 0) {
                    this.current_frame_index = this.frames.size() - 1;
                }
                this.ps3D = (Graphics3D)this.frames.elementAt(this.current_frame_index);
                continue;
            }
            if (this.animation_direction != 0) continue;
            ++this.current_frame_index;
            if (this.current_frame_index >= 2 * this.frames.size() - 2) {
                this.current_frame_index = 0;
            }
            this.ps3D = this.current_frame_index < this.frames.size() ? (Graphics3D)this.frames.elementAt(this.current_frame_index) : (Graphics3D)this.frames.elementAt(2 * this.frames.size() - this.current_frame_index - 2);
        }
    }

    Quaternion adjust_bg_offsets() {
        while (this.bg_x_offset > this.bg_width) {
            this.bg_x_offset -= this.bg_width;
        }
        while (this.bg_x_offset < 0) {
            this.bg_x_offset += this.bg_width;
        }
        double phi = Math.PI * -2 * (double)this.bg_x_offset / (double)this.bg_width;
        double theta = 0.0;
        if (this.bg_is_cylindrical) {
            int max_y_offset = (this.bg_height - this.applet_height) / 2;
            if (this.bg_y_offset > max_y_offset) {
                this.bg_y_offset = max_y_offset;
            } else if (this.bg_y_offset < -max_y_offset) {
                this.bg_y_offset = -max_y_offset;
            }
            theta = Math.PI * -2 * (double)this.bg_y_offset / (double)this.bg_width;
        } else if (this.bg_is_spherical) {
            while (this.bg_y_offset > this.bg_height + this.bg_height) {
                this.bg_y_offset = this.bg_y_offset - this.bg_height - this.bg_height;
            }
            while (this.bg_y_offset < 0) {
                this.bg_y_offset = this.bg_y_offset + this.bg_height + this.bg_height;
            }
            theta = -Math.PI * (double)this.bg_y_offset / (double)this.bg_height;
        }
        this.rotation = new Quaternion(theta, 1.0, 0.0, 0.0, false);
        this.rotation.multiply(new Quaternion(phi, 0.0, 1.0, 0.0, false));
        return this.rotation;
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        this.is_mouse_here = true;
        this.requestFocus();
        if (this.audio_enter != null) {
            this.audio_enter.play();
        }
        if (this.audio_loop_enter != null) {
            this.audio_loop_enter.loop();
        }
        if (this.initialized) {
            if (this.ps3D == null) {
                this.getAppletContext().showStatus(syntax_error_string);
                return true;
            }
            this.getAppletContext().showStatus(enter_string);
        } else {
            this.getAppletContext().showStatus(enter_init_string);
        }
        return true;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        this.is_mouse_here = false;
        if (this.audio_loop_enter != null) {
            this.audio_loop_enter.stop();
        }
        if (this.active_primitive != null) {
            this.drawTextRectangle(this.active_primitive);
            this.active_primitive = null;
            if (!this.is_dragging && !this.is_new_dragging && this.is_put_on_screen) {
                this.is_put_on_screen = false;
                this.repaint();
            }
        }
        return true;
    }

    public boolean mouseMove(Event evt, int x, int y) {
        this.is_mouse_here = true;
        if (!this.initialized || this.painted_ps3D == null || x < 0 || x > this.applet_width || y < 0 || y > this.applet_height || !this.is_put_on_screen) {
            return true;
        }
        this.mark_hyperlink(x, y);
        return true;
    }

    public synchronized void mark_hyperlink(int x, int y) {
        Primitive3D old_active_primitive = this.active_primitive;
        this.active_primitive = null;
        int[] pixel_xs = this.painted_ps3D.left_pixel_xs;
        int[] pixel_ys = this.painted_ps3D.pixel_ys;
        if (this.painted_ps3D.is_stereo && x > this.painted_ps3D.pixel_width) {
            pixel_xs = this.painted_ps3D.right_pixel_xs;
            x -= this.painted_ps3D.pixel_width;
        }
        int ordered_index = this.painted_ps3D.count_ordered_primitives - 1;
        while (ordered_index >= 0) {
            int primitive_index = this.painted_ps3D.order[ordered_index];
            if (this.painted_ps3D.min_primitive_index <= primitive_index && primitive_index <= this.painted_ps3D.max_primitive_index) {
                Primitive3D primitive = (Primitive3D)this.painted_ps3D.primitives.elementAt(primitive_index);
                if (primitive.font_url != null) {
                    if (primitive.count_points == 0) {
                        if (this.painted_ps3D.pixel_width / 2 + primitive.first_point <= x && 2 + primitive.second_point <= y && this.painted_ps3D.pixel_width / 2 + primitive.first_point + primitive.third_point >= x && 2 + primitive.second_point + primitive.fourth_point >= y) {
                            this.active_primitive = primitive;
                            break;
                        }
                    } else {
                        int point_index = primitive.points[0];
                        if (this.painted_ps3D.point_scale[point_index] > 0 && pixel_xs[point_index] + primitive.first_point <= x && pixel_ys[point_index] + primitive.second_point <= y && pixel_xs[point_index] + primitive.first_point + primitive.third_point >= x && pixel_ys[point_index] + primitive.second_point + primitive.fourth_point >= y) {
                            this.active_primitive = primitive;
                            break;
                        }
                    }
                }
            }
            --ordered_index;
        }
        if (old_active_primitive != this.active_primitive && (old_active_primitive != null || this.active_primitive != null)) {
            if (!this.is_put_on_screen) {
                this.active_primitive = null;
            } else {
                if (old_active_primitive != null) {
                    this.drawTextRectangle(old_active_primitive);
                    if (this.active_primitive == null) {
                        this.getAppletContext().showStatus(empty_string);
                    }
                }
                if (this.active_primitive != null) {
                    this.drawTextRectangle(this.active_primitive);
                    this.getAppletContext().showStatus(this.active_primitive.font_url);
                }
                this.is_put_on_screen = false;
                this.repaint();
            }
        }
    }

    public synchronized void drawTextRectangle(Primitive3D primitive) {
        if (primitive.count_points == 0) {
            this.graphics_buffer.setColor(Color.white);
            this.graphics_buffer.setXORMode(Color.black);
            this.graphics_buffer.drawRect(this.painted_ps3D.pixel_width / 2 + primitive.first_point, 2 + primitive.second_point, primitive.third_point - 1, primitive.fourth_point - 1);
            if (this.painted_ps3D.is_stereo) {
                this.graphics_buffer.drawRect(this.painted_ps3D.pixel_width + this.painted_ps3D.pixel_width / 2 + primitive.first_point, 2 + primitive.second_point, primitive.third_point - 1, primitive.fourth_point - 1);
            }
            this.graphics_buffer.setPaintMode();
        } else {
            int point_index = primitive.points[0];
            if (this.painted_ps3D.point_scale[point_index] > 0) {
                this.graphics_buffer.setColor(Color.white);
                this.graphics_buffer.setXORMode(Color.black);
                this.graphics_buffer.drawRect(this.painted_ps3D.left_pixel_xs[point_index] + primitive.first_point, this.painted_ps3D.pixel_ys[point_index] + primitive.second_point, primitive.third_point - 1, primitive.fourth_point - 1);
                if (this.painted_ps3D.is_stereo) {
                    this.graphics_buffer.drawRect(this.painted_ps3D.pixel_width + this.painted_ps3D.right_pixel_xs[point_index] + primitive.first_point, this.painted_ps3D.pixel_ys[point_index] + primitive.second_point, primitive.third_point - 1, primitive.fourth_point - 1);
                }
                this.graphics_buffer.setPaintMode();
            }
        }
    }

    public boolean mouseDown(Event evt, int x, int y) {
        this.is_mouse_here = true;
        if (this.painted_ps3D == null) {
            return true;
        }
        if (this.active_primitive != null) {
            URL new_url;
            try {
                new_url = new URL(this.active_primitive.font_url);
            }
            catch (MalformedURLException e) {
                this.getAppletContext().showStatus(String.valueOf(url_error_string) + e.getMessage());
                new_url = null;
            }
            if (new_url != null) {
                this.getAppletContext().showDocument(new_url);
            }
        } else {
            long new_down_time = evt.when;
            if (new_down_time > this.down_time && new_down_time - this.down_time < 500L) {
                this.is_animating ^= true;
                this.down_time = new_down_time - 1000L;
            } else {
                this.down_time = new_down_time;
            }
            this.is_dragging = true;
            this.preceding_rotation = this.rotation;
            this.preceding_length_view_point_factor = this.length_view_point_factor;
            this.preceding_magnification_factor = this.magnification_factor;
            this.preceding_cut_primitives_count = this.cut_primitives_count;
            this.preceding_bg_x_offset = this.bg_x_offset;
            this.preceding_bg_y_offset = this.bg_y_offset;
            this.preceding_stereo_distance = this.stereo_distance;
            this.preceding_frame_index = this.current_frame_index;
            this.down_mouse_x = x;
            this.down_mouse_y = y;
            this.last_x = this.down_mouse_x;
            this.last_y = this.down_mouse_y;
            this.last_drag_time = evt.when;
            this.is_spinning = false;
            this.spin_x = 0;
            this.spin_y = 0;
            this.is_shift_down = false;
            this.is_control_down = false;
            this.is_meta_down = false;
            if (evt.shiftDown()) {
                this.is_shift_down = true;
            } else if (evt.controlDown()) {
                this.is_control_down = true;
            } else if (evt.metaDown()) {
                this.is_meta_down = true;
            }
        }
        return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        if (!this.is_shift_down && !this.is_meta_down && !this.is_control_down && this.is_mouse_here && this.llast_drag_time != 0L) {
            this.calculateSpin(evt, x, y);
        } else {
            this.is_spinning = false;
            this.spin_x = 0;
            this.spin_y = 0;
        }
        this.llast_drag_time = 0L;
        this.is_dragging = false;
        this.is_shift_down = false;
        this.is_meta_down = false;
        this.is_control_down = false;
        return true;
    }

    void calculateSpin(Event evt, int x, int y) {
        int final_x = this.last_x;
        int final_y = this.last_y;
        long final_time = this.last_drag_time;
        int initial_x = this.llast_x;
        int initial_y = this.llast_y;
        long initial_time = this.llast_drag_time;
        if (x == this.last_x && y == this.last_y && (evt.when - final_time > 500L || evt.when >= final_time + (final_time - initial_time) + (final_time - initial_time))) {
            this.spin_x = 0;
            this.spin_y = 0;
        } else {
            if (evt.when > final_time) {
                final_x = x;
                final_y = y;
                final_time = evt.when;
            }
            if (final_time <= initial_time) {
                this.spin_x = 0;
                this.spin_y = 0;
            } else {
                double abs;
                double time_scale = this.animation_display_time;
                if (time_scale < 0.005) {
                    time_scale = 0.005;
                }
                double time_fraction = 1000.0 * time_scale / (double)(final_time - initial_time);
                this.spin_x = (int)(time_fraction * (double)(final_x - initial_x));
                this.spin_y = (int)(time_fraction * (double)(final_y - initial_y));
                if (Math.abs(this.spin_x) + Math.abs(this.spin_y) > this.min_height_width / 8 && (abs = Math.sqrt((double)this.spin_x * (double)this.spin_x + (double)this.spin_y * (double)this.spin_y)) > (double)(this.min_height_width / 8)) {
                    this.spin_x = (int)((double)this.spin_x / abs * (double)(this.min_height_width / 8));
                    this.spin_y = (int)((double)this.spin_y / abs * (double)(this.min_height_width / 8));
                }
            }
        }
        this.is_spinning = this.spin_x != 0 || this.spin_y != 0;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        if (this.ps3D == null || this.active_primitive != null || !this.is_dragging) {
            return true;
        }
        if (this.preceding_rotation != null && (x != this.last_x || y != this.last_y)) {
            this.is_new_dragging = true;
            if (this.is_shift_down || this.is_control_down || this.is_meta_down) {
                if (Math.abs(this.last_x - x) > Math.abs(this.last_y - y)) {
                    this.down_mouse_y = this.down_mouse_y + y - this.last_y;
                } else {
                    this.down_mouse_x = this.down_mouse_x + x - this.last_x;
                }
            }
            if (this.last_drag_time != evt.when) {
                this.llast_x = this.last_x;
                this.llast_y = this.last_y;
                this.llast_drag_time = this.last_drag_time;
            }
            this.last_x = x;
            this.last_y = y;
            this.last_drag_time = evt.when;
            this.spin_x = 0;
            this.spin_y = 0;
            this.is_spinning = false;
        }
        return true;
    }

    public boolean keyDown(Event evt, int key) {
        if (this.painted_ps3D == null) {
            return true;
        }
        if (key == 111) {
            double[] dArray = new double[3];
            dArray[2] = 1.0;
            double[] view_point = dArray;
            double[] dArray2 = new double[3];
            dArray2[1] = 1.0;
            double[] view_vertical = dArray2;
            view_point = this.painted_ps3D.getQuaternion().conjugated().rotated(view_point);
            view_vertical = this.painted_ps3D.getQuaternion().conjugated().rotated(view_vertical);
            String options = "LiveGraphics3D parameters:\n   <PARAM NAME=MAGNIFICATION VALUE=" + this.magnification_factor + ">\n";
            if (this.is_stereo) {
                options = String.valueOf(options) + "   <PARAM NAME=STEREO_DISTANCE VALUE=" + this.stereo_distance + ">\n";
            }
            options = String.valueOf(options) + "Graphics3D options:\n   ViewPoint->{" + view_point[0] * this.painted_ps3D.length_view_point + ", " + view_point[1] * this.painted_ps3D.length_view_point + ", " + view_point[2] * this.painted_ps3D.length_view_point + "},\n   ViewVertical->{" + view_vertical[0] / this.painted_ps3D.option_BoxRatios[0] + ", " + view_vertical[1] / this.painted_ps3D.option_BoxRatios[1] + ", " + view_vertical[2] / this.painted_ps3D.option_BoxRatios[2] + "}";
            System.out.println(options);
        } else if (key == 115) {
            if (!this.is_stereo) {
                this.is_stereo = true;
            } else if (this.stereo_distance > 0.0) {
                this.stereo_distance = -this.stereo_distance;
                if (this.stereo_distance > 0.0) {
                    this.stereo_distance = -0.05;
                }
            } else {
                this.stereo_distance = -this.stereo_distance;
                this.is_stereo = false;
            }
            this.is_new_dragging = true;
        }
        return true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.image_buffer != null) {
            g.drawImage(this.image_buffer, 0, 0, this);
            this.is_put_on_screen = true;
        }
    }

    public void paintGraphics3D() {
        this.active_primitive = null;
        if (this.ps3D.is_stereo && this.second_graphics_buffer == null) {
            this.second_image_buffer = this.createImage((this.applet_width + 1) / 2, this.applet_height);
            this.second_graphics_buffer = this.second_image_buffer.getGraphics();
        }
        if (this.bg_image == null) {
            this.graphics_buffer.setColor(this.ps3D.option_Background);
            this.graphics_buffer.fillRect(0, 0, this.ps3D.pixel_width, this.ps3D.pixel_height);
            if (this.ps3D.is_stereo) {
                this.second_graphics_buffer.setColor(this.ps3D.option_Background);
                this.second_graphics_buffer.fillRect(0, 0, this.ps3D.pixel_width, this.ps3D.pixel_height);
            }
        } else {
            Image first_bg_image = this.bg_image;
            Image first_bg_rotated_image = this.bg_rotated_image;
            Image second_bg_image = this.bg_right_image;
            Image second_bg_rotated_image = this.bg_rotated_right_image;
            if (this.ps3D.is_stereo && this.ps3D.stereo_distance < 0.0) {
                first_bg_image = this.bg_right_image;
                first_bg_rotated_image = this.bg_rotated_right_image;
                second_bg_image = this.bg_image;
                second_bg_rotated_image = this.bg_rotated_image;
            }
            if (this.bg_is_spherical) {
                int x;
                int x2;
                int bg_rotated_x_offset = (this.bg_width / 2 + this.bg_width - this.bg_x_offset) % this.bg_width;
                int start_y = ((this.ps3D.pixel_height - this.bg_height) / 2 + this.bg_height + this.bg_y_offset) % (this.bg_height + this.bg_height) - this.bg_height;
                int start_x = 0;
                if (start_y > 0) {
                    x2 = start_x = ((this.ps3D.pixel_width + this.bg_width) / 2 + bg_rotated_x_offset - this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                    while (x2 < this.ps3D.pixel_width) {
                        this.graphics_buffer.drawImage(first_bg_rotated_image, x2, start_y - this.bg_height, null);
                        x2 += this.bg_width;
                    }
                    if (this.ps3D.is_stereo) {
                        x = start_x = ((this.ps3D.pixel_width + this.bg_width) / 2 + bg_rotated_x_offset + this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                        while (x < this.ps3D.pixel_width) {
                            this.second_graphics_buffer.drawImage(second_bg_rotated_image, x, start_y - this.bg_height, null);
                            x += this.bg_width;
                        }
                    }
                }
                x2 = start_x = ((this.ps3D.pixel_width + this.bg_width) / 2 + this.bg_x_offset - this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                while (x2 < this.ps3D.pixel_width) {
                    this.graphics_buffer.drawImage(first_bg_image, x2, start_y, null);
                    x2 += this.bg_width;
                }
                if (this.ps3D.is_stereo) {
                    x = start_x = ((this.ps3D.pixel_width + this.bg_width) / 2 + this.bg_x_offset + this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                    while (x < this.ps3D.pixel_width) {
                        this.second_graphics_buffer.drawImage(second_bg_image, x, start_y, null);
                        x += this.bg_width;
                    }
                }
                if (start_y + this.bg_height < this.ps3D.pixel_height) {
                    x = start_x = ((this.ps3D.pixel_width + this.bg_width) / 2 + bg_rotated_x_offset - this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                    while (x < this.ps3D.pixel_width) {
                        this.graphics_buffer.drawImage(first_bg_rotated_image, x, start_y + this.bg_height, null);
                        x += this.bg_width;
                    }
                    if (this.ps3D.is_stereo) {
                        int x3 = start_x = ((this.ps3D.pixel_width + this.bg_width) / 2 + bg_rotated_x_offset + this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                        while (x3 < this.ps3D.pixel_width) {
                            this.second_graphics_buffer.drawImage(second_bg_rotated_image, x3, start_y + this.bg_height, null);
                            x3 += this.bg_width;
                        }
                    }
                }
            } else {
                int start_y;
                int local_pixel_stereo_offset = this.ps3D.pixel_stereo_offset;
                if (this.bg_is_fixed) {
                    local_pixel_stereo_offset = 0;
                }
                int y = start_y = ((this.ps3D.pixel_height + this.bg_height) / 2 + this.bg_y_offset) % this.bg_height - this.bg_height;
                while (y < this.ps3D.pixel_height) {
                    int start_x;
                    int x = start_x = ((this.ps3D.pixel_width + this.bg_width) / 2 + this.bg_x_offset - local_pixel_stereo_offset) % this.bg_width - this.bg_width;
                    while (x < this.ps3D.pixel_width) {
                        this.graphics_buffer.drawImage(first_bg_image, x, y, null);
                        x += this.bg_width;
                    }
                    if (this.ps3D.is_stereo) {
                        int x4 = start_x = ((this.ps3D.pixel_width + this.bg_width) / 2 + this.bg_x_offset + local_pixel_stereo_offset) % this.bg_width - this.bg_width;
                        while (x4 < this.ps3D.pixel_width) {
                            this.second_graphics_buffer.drawImage(second_bg_image, x4, y, null);
                            x4 += this.bg_width;
                        }
                    }
                    y += this.bg_height;
                }
            }
        }
        this.ps3D.paint(this.graphics_buffer, this.second_graphics_buffer, this.second_image_buffer);
        this.painted_ps3D = this.ps3D;
        this.repaint();
    }

    public Live() {
        this.applet_width = this.size().width;
        this.applet_height = this.size().height;
        this.is_dragging = false;
        this.audio_enter = null;
        this.audio_loop_enter = null;
        this.audio_first_frame = null;
        this.down_mouse_x = 50;
        this.down_mouse_y = 50;
        this.down_time = 0L;
        this.last_x = 50;
        this.last_y = 50;
        this.last_drag_time = 0L;
        this.llast_x = 50;
        this.llast_y = 50;
        this.llast_drag_time = 0L;
        this.is_control_down = false;
        this.is_meta_down = false;
        this.is_shift_down = false;
        this.is_mouse_here = false;
        this.length_view_point_factor = 1.0;
        this.magnification_factor = 1.0;
        this.cut_primitives_count = 0;
        this.rotation = new Quaternion(1.0, 0.0, 0.0, 0.0);
        this.bg_x_offset = 0;
        this.bg_y_offset = 0;
        this.stereo_distance = 0.05;
        this.preceding_length_view_point_factor = 1.0;
        this.preceding_magnification_factor = 1.0;
        this.preceding_cut_primitives_count = 0;
        this.preceding_rotation = this.rotation;
        this.preceding_bg_x_offset = 0;
        this.preceding_bg_y_offset = 0;
        this.preceding_stereo_distance = 0.05;
        this.preceding_frame_index = 0;
        this.is_new_dragging = false;
        this.initialized = false;
    }
}

